<?php

namespace Modules\Seller\Models;

use  Illuminate\Database\Eloquent\Model;

class ProductSku extends Model
{
    protected $table = 'product_sku';

    protected $fillable = [
        'sku',
        'barcode',
        'price',
        'high_price',
        'image_url',
        'product_id',
        'is_default',
        'sale_percent',
        'display_drop_price',
        'inventory'
    ];
    protected $appends = ['product_name'];

    public function skuValues()
    {
        return $this->hasMany(ProductSkuValue::class, 'sku_id', 'id');
    }

    public function galleries()
    {
        return $this->hasMany(ProductGallery::class, 'product_id', 'id')->where('type', 'VARIANT');
    }
}
