<?php

namespace Modules\Seller\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model
{
    protected $table = 'users';
    CONST SELLER_ROLE = 'SELLER';
    CONST ACTIVE_STATUS = 'ACTIVE';
    CONST PENDING_STATUS = 'PENDING';
    CONST SUSPENDED_STATUS = 'SUSPENDED';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'image_avatar', 'image_background', 'slug', 'token', 'seller_token', 'role', 'status'
    ];
    
    public function products ()
    {
        return $this->hasMany(Product::class, 'id', 'actor_id');

    }
    
}
