system.controller("SellerInvoiceController", SellerInvoiceController);
function SellerInvoiceController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );
    $scope.invoices = [];
    $scope.statuses = ["PENDING", "PAID", "ONHOLD"];
    $scope.filter = {
        status: undefined,
        dateFrom: "",
        dateTo: "",
    };

    $scope.initalize = () => {
        getInvoices();
    };

    $scope.find = () => {
        getInvoices();
    };

    const getInvoices = () => {
        const url = buildUrl();
        fetch(url)
            .then((response) => response.json())
            .then((data) => {
                if (data.status == "successful") {
                    $scope.$applyAsync(() => {
                        $scope.invoices = data.result;
                        $scope.meta = data.meta;
                    });
                }
            });
    };

    $scope.updatedInvoice = (invoice, key, value) => {
        if (confirm("Are you sure to change payment status to " + value)) {
            $http.patch(`/service/seller/invoice/change-status/` + invoice.id,
                {
                    status: value
                }
            )
                .then((response) => response.json())
                .then((data) => {
                    if (data.status == "successful") {
                        toastr.success("Change payment status successful");
                    }
                });
        }
    };

    const buildUrl = () => {
        let url =
            "/service/seller/invoice" +
            "?page_size=" +
            $scope.meta.page_size +
            "&page_id=" +
            $scope.meta.page_id;
        if ($scope.filter["search"]) {
            url += "&search=" + $scope.filter["search"];
        }
        if ($scope.filter["status"]) {
            url += "&payment_status=" + $scope.filter["status"];
        }
        if ($scope.filter["dateFrom"]) {
            url +=
                "&date_from=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateFrom);
        }
        if ($scope.filter["dateTo"]) {
            url +=
                "&date_to=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateTo);
        }
        return url;
    };

    $scope.exportExcel = () => {
        let url = buildUrl();
        url += '&export_excel=1'
        window.location.href = url;
    }

    $scope.clear = () => {
       $scope.filter = {
           status: undefined,
           dateFrom: "",
           dateTo: "",
       }; 
       $scope.find(); 
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.initalize();
}
