system.controller("FakeSellersController", FakeSellersController);

function FakeSellersController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    
    $scope.fakeSellers = [];
    $scope.editingSeller = null;
    $scope.statuses = ['ACTIVE', 'PENDING', 'SUSPENDED'];
    $scope.filter = {
        
    };
    $scope.checkAll = false;
    $scope.totalSelected = 0;

    const initalize = () => {
         getFakeSellers();
    }


    const getFakeSellers = () => {
        const url = buildUrl();
        $http.get(url).then((res) => {
            if (res.data.status == "successful") {
                $scope.fakeSellers = res.data.result;
                $scope.meta = res.data.meta;
            }
        });

    }
    const buildUrl = () => {
        let url =
            baseApiUrl + "/users?filters=role={SELLER;STAFF},seller_token=NULL";
        if ($scope.filter.search) {
            url += ',name~' + $scope.filter.search;
        }
        url += 
            "&page_size=" +
            $scope.meta.page_size +
            "&page_id=" +
            $scope.meta.page_id;
            return url;
    }

    $scope.find = () => {
        getFakeSellers();
        $scope.checkAll = false;
        $scope.totalSelected = 0;
    }

    $scope.removeFakeSellers = (seller) => {
        if (confirm("Do you want fake seller?")) {
            $http.delete('/service/seller/remove-fake?id=' + seller.id).then((res) => {
                if (res.data.status === 'successful') {
                    
                } else {
                    toastr.error("An error occurred");
                }
            })
        }
    }
    $scope.transferProductToOtherSeller  = (seller) => {
        if (confirm("Are you sure?")) {
            seller.message = "Transfering...";
           $http
               .get("/service/seller/product-ids?id=" + seller.id)
               .then((res) => {
                   if (res.data.status === "successful") {
                       if (res.data.result.length === 0) {
                            seller.message = null;
                           toastr.warning("List product is empty!!"); 
                       }else {
                           return $http
                               .post(
                                   baseApiUrl +
                                       "/service/random-product-seller",
                                   {
                                       product_ids: res.data.result,
                                       ignore_seller_ids: [seller.id],
                                   }
                               )
                               .then((res) => {
                                   if (res.data.status === "successful") {
                                       seller.message = null;
                                       toastr.success("Successful");
                                   }
                               });
                       }
                   } else {
                       toastr.error("An error occurred");
                   }
               }); 
            

        }
    }

    $scope.uploadImage = (files, type, seller) => {
        if(files.length > 0) {
            $scope.upload(files[0]).then((imageUrl) => {
                $scope.$applyAsync(() => {
                    seller[type] = imageUrl;
                })
                // console.log(imageUrl);
            });
        }
    }

    $scope.updateFakeSeller = (seller) => {
       $http
           .patch(baseApiUrl + "/users/" + seller.id, {
               name: seller.name,
               slug: seller.slug,
               status: seller.status,
               image_avatar: seller.image_avatar,
               image_background: seller.image_background,
           })
           .then((res) => {
               if (res.data.status === "successful") {
                   seller.editting = false;
               }
           }); 
    }
    $scope.clear = () => {
        $scope.filter = {};
        $scope.meta.page_id = 0;
        $scope.find();
    }
    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(true);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(true);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(true);
        }
    };

    $scope.checkAllSeller = function () {
        $scope.fakeSellers.forEach(seller => {
            seller.is_checked = $scope.checkAll;
        });
        if ($scope.checkAll) {
            $scope.totalSelected = $scope.fakeSellers.length;
        } else {
            $scope.totalSelected = 0;
        }
    }


    $scope.checkOneSeller = function () {
        var checkAll = true;
        $scope.totalSelected = 0;
        $scope.fakeSellers.forEach(seller => {
            if (!seller.is_checked) {
                checkAll = false;
            } else {
                $scope.totalSelected++
            }
             
        });
        $scope.checkAll = checkAll;
    }

    $scope.bulkChangeStatus = function name(status) {
        if (confirm("Are you sure to change " + $scope.totalSelected + " seller status to " + status)) {
            $scope.fakeSellers.forEach(seller => {
                if (seller.is_checked && seller.payment_status != status) {
                    seller.status = status;
                    $scope.changeSellerStatus(seller);
                }
            });
        }
    }

    $scope.changeSellerStatus = (seller) => {
        $http.patch(baseApiUrl + "/users/" + seller.id, {
            status: seller.status,
        })
        .then((res) => {
        }); 
     }
    initalize();
}