system.controller("SellerDashboardController", SellerDashboardController);
function SellerDashboardController($scope, $http, $rootScope, Upload, $timeout) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );

    Highcharts.setOptions({
        lang: {
            thousandsSep: ""
        }
    });

    $scope.localizationColor = ["#7cb5ec", "#f7a35c", "#8085e9", "#f15c80", "#e4d354", "#2b908f", "#f45b5b", "#058DC7", "#e7540c", "#6078ae", "#90ed7d"];
    let dataChartGrowthSellerRate = [
        {
            name: 'Số seller',
            data: [],
            type: 'column'
        },
        {
            name: 'Mức độ tăng trưởng (%)',
            data: [],
            type: 'spline',
            yAxis: 1
        }
    ];
    let dataChartProductSubmittedBySeller = [{
        name: 'Đã được duyệt',
        data: [],
    }, {
        name: 'Đang chờ duyệt',
        data: [],
    },
    {
        name: 'Đã được feed',
        data: [],
    }];
    let dataChartOrdersSeller = [{
        name: 'Số đơn hàng',
        data: [],
    },
    {
      name: 'Commission',
      data: [],
      type: 'spline',
      yAxis: 1
  },
  {
      name: 'Revenue',
      data: [],
      type: 'spline',
      yAxis: 1
  }
  ];

    $scope.chartSellerGrowthRate;
    $scope.chartProductSubmittedByTheSeller;
    $scope.chartOrdersSeller;
    $scope.chartRevenueByCategory;
    $scope.statisticSeller = {
        total_seller: 0,
        total_new_seller: 0,
        total_order: 0,
        total_revenue: 0
    }

    $scope.initialize = () => {
        $timeout(function () {
            $("#date-from").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "-1w");

            $("#date-to").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "+0");
        })
        $scope.getStatisticSeller();
        let xCategories = [];
        Promise.all([
            $scope.sellerGrowthRate({ xCategories, series: dataChartGrowthSellerRate }),
            $scope.productSubmittedBySeller({ xCategories, series: dataChartProductSubmittedBySeller }),
            $scope.ordersSeller({ xCategories, series: dataChartOrdersSeller }),
            $scope.chartRevenueByCategory(),
        ]).then(function () {
            $scope.getDataChart();
        });
    };

    $scope.buildFilter = function(url)
    {
        if ($scope.filter && $scope.filter.dateFrom && $scope.filter.dateTo) {
            url += '?dateFrom=' + $scope.filter.dateFrom  + '&dateTo=' +  $scope.filter.dateTo;
        }
        return url;
    }

    $scope.getDataChart = () => {
        $scope.getDataSellerGrowthRate();
        $scope.getDataProductSubmittedByTheSeller();
        $scope.getDataOrdersSeller();
        $scope.getRevenueSeller();
    }

    $scope.getDataSellerGrowthRate = () => {
        $scope.chartSellerGrowthRate.showLoading();
        var url = '/module/seller/dashboard/get-seller-growth-rate';
        url = $scope.buildFilter(url);
        $http.get(url)
            .then((res) => {
                if (res.data.status == 'successful') {
                    let dataResponse = res.data.result;
                    let dataXCategories = [];

                    dataChartGrowthSellerRate[0].data = [];
                    dataChartGrowthSellerRate[1].data = [];
                    for (const item in dataResponse) {
                        const valueItem = dataResponse[item];
                        dataXCategories.push(valueItem.date);
                        dataChartGrowthSellerRate[0].data.push(valueItem.count_seller);
                        dataChartGrowthSellerRate[1].data.push(valueItem.growth_rate);
                    }

                    $scope.chartSellerGrowthRate.xAxis[0].setCategories(dataXCategories);

                    try {
                        for (let index = 0; index < $scope.chartSellerGrowthRate.series.length; index++) {
                            $scope.chartSellerGrowthRate.series[index].setData(dataChartGrowthSellerRate[index].data);
                        }
                    } catch (error) {}
                    
                    $scope.chartSellerGrowthRate.hideLoading();
                }
            })
            .catch((err) => {
            });
    }

    $scope.getDataProductSubmittedByTheSeller = () => {
        $scope.chartProductSubmittedByTheSeller.showLoading();
        var url = '/module/seller/dashboard/get-product-submitted-by-the-seller';
        url = $scope.buildFilter(url);
        $http.get(url)
            .then((res) => {
                if (res.data.status == 'successful') {
                    let dataResponse = res.data.result;
                    let dataXCategories = [];
                    dataChartProductSubmittedBySeller[0].data = [];
                    dataChartProductSubmittedBySeller[1].data = [];
                    dataChartProductSubmittedBySeller[2].data = [];
                    for (const item in dataResponse) {
                        const valueItem = dataResponse[item];
                        dataXCategories.push(valueItem.date);
                        dataChartProductSubmittedBySeller[0].data.push(valueItem.number_approved);
                        dataChartProductSubmittedBySeller[1].data.push(valueItem.number_pending);
                        dataChartProductSubmittedBySeller[2].data.push(valueItem.number_feed);
                    }

                    $scope.chartProductSubmittedByTheSeller.xAxis[0].setCategories(dataXCategories);

                    try {
                        for (let index = 0; index < $scope.chartProductSubmittedByTheSeller.series.length; index++) {
                            $scope.chartProductSubmittedByTheSeller.series[index].setData(dataChartProductSubmittedBySeller[index].data);
                        }
                    } catch (error) { }
                }
                $scope.chartProductSubmittedByTheSeller.hideLoading();
            })
            .catch((err) => {
                $scope.chartProductSubmittedByTheSeller.hideLoading();
            });
    }

  $scope.getDataOrdersSeller = () => {
    $scope.chartOrdersSeller.showLoading();
    var url = "/module/seller/dashboard/get-total-orders-by-the-seller";
    url = $scope.buildFilter(url);
    $http
      .get(url)
      .then((res) => {
        if (res.data.status == "successful") {
          let dataResponse = res.data.result;
          let dataXCategories = [];
          dataChartOrdersSeller[0].data = [];
          dataChartOrdersSeller[1].data = [];
          dataChartOrdersSeller[2].data = [];
          for (const item in dataResponse) {
            const valueItem = dataResponse[item];
            dataXCategories.push(valueItem.date);
            dataChartOrdersSeller[0].data.push(valueItem.count_order);
            dataChartOrdersSeller[1].data.push(valueItem.commission);
            dataChartOrdersSeller[2].data.push(valueItem.revenue);
          }

          $scope.chartOrdersSeller.xAxis[0].setCategories(dataXCategories);

          try {
            for (
              let index = 0;
              index < $scope.chartOrdersSeller.series.length;
              index++
            ) {
              $scope.chartOrdersSeller.series[index].setData(
                dataChartOrdersSeller[index].data
              );
            }
          } catch (error) {}
        }

        $scope.chartOrdersSeller.hideLoading();
      })
      .catch((err) => {
        $scope.chartOrdersSeller.hideLoading();
      });
  };

    $scope.sellerGrowthRate = function (data) {
        if (!document.getElementById('seller-growth-rate')) {
            return;
        }

        return new Promise(function (resolve) {
            $timeout(function () {
                $scope.chartSellerGrowthRate = Highcharts.chart('seller-growth-rate', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null,
                    },
                    xAxis: {
                        categories: data.xCategories
                    },
                    yAxis:
                        [{
                            min: 0,
                            title: {
                                text: 'Số seller'
                            }
                        }, {
                            min: 0,
                            title: {
                                text: 'Mức độ tăng trưởng (%)'
                            },
                            opposite: true
                        }],
                    credits: {
                        enabled: false
                    },
                    tooltip: {
                        shared: true,
                        format: '<b>{key}</b><br/>{series.name}: {y}<br/>' +
                            'Total: {point.stackTotal}'
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal'
                        }
                    },
                    colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: data.series,
                });

                resolve();
            }, 100);
        });

    }

    $scope.productSubmittedBySeller = function (data) {
        if (!document.getElementById('product-submitted-by-the-seller')) {
            return;
        }

        return new Promise(function (resolve) {
            $timeout(function () {
                $scope.chartProductSubmittedByTheSeller = Highcharts.chart('product-submitted-by-the-seller', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: null,
                    },
                    xAxis: {
                        categories: data.xCategories
                    },
                    yAxis: {
                        allowDecimals: false,
                        min: 0,
                        title: {
                            text: null
                        }
                    },
                    tooltip: {
                        shared: true,
                        format: '<b>{key}</b><br/>{series.name}: {y}<br/>' +
                            'Total: {point.stackTotal}'
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal'
                        }
                    },
                    colors: ['#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'].concat($scope.localizationColor),
                    series: data.series
                });
                resolve();
            }, 100);
        });
      }
  $scope.ordersSeller = function (data) {
    if (!document.getElementById("orders-seller")) {
      return;
    }

    return new Promise(function (resolve) {
      $timeout(function () {
        $scope.chartOrdersSeller = Highcharts.chart("orders-seller", {
          chart: {
            type: "column",
          },
          title: {
            text: null,
          },
          xAxis: {
            categories: data.xCategories,
          },
          yAxis:[
            {
              min: 0,
              title: {
                text: "Số đơn hàng",
              },
            },
            {
              title: {
                text: "Số tiền Revenue, Commission",
              },
              opposite: true,
            },
          ],
          credits: {
            enabled: false,
          },
          tooltip: {
            shared: true,
            format:
              "<b>{key}</b><br/>{series.name}: {y}<br/>" +
              "Total: {point.stackTotal}",
          },
          plotOptions: {
            column: {
              stacking: "normal",
            },
          },
          colors: ["#FF9655", "#8085e9", "#058DC7"].concat(
            $scope.localizationColor
          ),
          series: data.series,
        });
        resolve();
      }, 100);
    });
  };

    $scope.chartRevenueByCategory = function (data = [], categories = []) {

        if (!document.getElementById('revenue-seller')) {
            return;
        }

        return new Promise(function (resolve) {
            $timeout(function () {
                $scope.chartRevenueByCategory = buildRevenue(data, categories);
                resolve();
            }, 100);
        });
    }

    var onLegendClick= function (event) {
        var myname = this.name;
        var myvis  = !this.visible;
        this.chart.series.forEach( function (elem) {
           if (elem.name == myname) {
              elem.setVisible(myvis);
           }
        });
        return false;
     }

    function buildRevenue(data = [], categories = []) {
        if (data) {
            data.forEach(function (serie) {
                serie.events = { legendItemClick : onLegendClick} ;    
            });
        }
        Highcharts.chart('revenue-seller', {

            chart: {
                type: 'column'
            },

            title: {
                text: '',
                align: 'left'
            },

            xAxis: 
                {
                    categories: categories
                }
            ,

            yAxis: [
                {
                    allowDecimals: false,
                    min: 0,
                    visible: false,
                    position: 'left'
                },
                {
                    allowDecimals: false,
                    min: 0,
                    visible: false,
                    position: 'right',
                    scalePositionLeft: false
                }
            ],

            tooltip: {
                headerFormat: '<b>{series.userOptions.stack_name}: {point.x}</b><br/>',
                pointFormat: '{series.name}: {point.y}{series.userOptions.unit}<br/>Total: {point.stackTotal}{series.userOptions.unit}'
            },

            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },

            series: data
        });
    }

    $scope.getRevenueSeller = () => {
        var url = '/module/seller/dashboard/get-revenue-by-category';
        url = $scope.buildFilter(url);
        $http.get(url)
            .then((res) => {
                if (res.data.status == 'successful') {
                    let dataResponse = res.data.result;
                    $scope.chartRevenueByCategory = buildRevenue(dataResponse, res.data.days);
                }

            })
            .catch((err) => {
            });
    }

    $scope.getReportByTine = function() {
        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();
        if (!dateFrom || dateFrom == '') {
            toastr.error('Mời chọn ngày bắt đầu Thống kê.');
            return;
        }
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn kết thúc Thống kê.');
            return;
        }
        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        if (dateFrom.getTime() >= dateTo.getTime()) {
            toastr.error('Ngày Bắt đầu thống kê phải nhỏ hơn ngày Kết thúc.');
            return;
        }

        $scope.filter = {
            dateFrom: dateFrom.getTime() / 1000,
            dateTo: dateTo.getTime() / 1000
        };
        $scope.getStatisticSeller();
        $scope.getDataChart();
    }

    $scope.getStatisticSeller = function() {    
        var url = '/module/seller/dashboard/get-statistic-all';
        url = $scope.buildFilter(url);
        if ($scope.filter && $scope.filter.dateFrom) {
            url += '&auth_key=kjmaskdlk';
        } else {
            url += '?auth_key=kjmaskdlk&ranger=7';
        }
        $http.get(url)
        .then((res) => {
            if (res.data.status == 'successful') {
                $scope.statisticSeller = res.data.result;
            }

        })
        .catch((err) => {
        
        });
    }

    $scope.initialize();
}
