system.controller("SellerInvoiceController", SellerInvoiceController);
function SellerInvoiceController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );
    $scope.invoices = [];
    $scope.weekInvoices = [];
    $scope.statuses = ["PENDING", "PAID", "ONHOLD"];
    $scope.weeklyStatuses = ["PENDING", "PAID", "PREPARE"];
    $scope.filter = {
        status: "PENDING",
        dateFrom: "",
        dateTo: "",
        weekly_payment_status: 'PENDING'
    };
    $scope.filterWeek = {};
    $scope.metaInvoiceMonthly = null;
    $scope.metaInvoiceWeekly = null;
    $scope.defaultMeta = null;
    let isMonthly = true;
    $scope.checkAll = false;
    $scope.totalInvoiceSelected = 0;

    $scope.initalize = () => {
        getInvoices();
        getInvoiceWeek();
        $scope.defaultMeta = angular.copy($scope.meta);
    };

    $scope.find = () => {
        getInvoices();
        $scope.checkAll = false;
        $scope.totalInvoiceSelected = 0;
    };

    $scope.findWeek = () => {
        getInvoiceWeek();
    }

    const getInvoices = () => {
        $scope.filterWeek.weekly = null;
        const url = buildUrl();
        
        fetch(url)
            .then((response) => response.json())
            .then((data) => {
                if (data.status == "successful") {
                    $scope.$applyAsync(() => {
                        $scope.invoices = data.result;
                        $scope.metaInvoiceMonthly = data.meta;
                        setMetaData();
                    });
                }
            }).catch((err) => {
                console.log(err);
            });
    };

    function getInvoiceWeek () {
        $scope.filterWeek.weekly = 1;
        const url = buildUrl();
        fetch(url, {
            method: 'GET'
        })
        .then((response) => response.json())
        .then((data) => {
            if (data.status == "successful") {
                $scope.$applyAsync(() => {
                    $scope.weekInvoices = data.result;
                    $scope.metaInvoiceWeekly = data.meta;
                    setMetaData();
                });
            }
        }).catch((err) => {
            console.log(err);
        });
    }

    $scope.changeTab = function(type) {
        if(type == 'monthly') {
            isMonthly = true;
        }
        if(type == 'weekly') {
            isMonthly = false;
        }
        setMetaData();
    }

    function setMetaData () {
        if(isMonthly) {
            $scope.meta = $scope.metaInvoiceMonthly ?? angular.copy($scope.defaultMeta);
        } else {
            $scope.meta = $scope.metaInvoiceWeekly ?? angular.copy($scope.defaultMeta);
        }
    }

    $scope.updatedInvoice = (invoice, key, value) => {
        if (confirm("Are you sure to change payment status to " + value)) {
            $scope.callApiUpdateInvoice(invoice, key, value);
        }
    };

    $scope.callApiUpdateInvoice = function (invoice, key, value, $toastr = true) {
        fetch(
            sellerUrl +
                `/api/service-system/invoice/update?token=Megamega@123&actor_email=${userLogin.email}&id=` +
                invoice.id +
                "&" +
                key +
                "=" +
                value,
            {
                method: "PATCH",
            }
        )
            .then((response) => response.json())
            .then((data) => {
                if (data.status == "successful" && toastr) {
                    toastr.success("Change payment status successful");
                }
            });
    }

    const buildUrl = () => {
        let url =
            sellerUrl +
            "/api/service-system/invoice/find?token=Megamega@123&" +
            "page_size=" +
            $scope.meta.page_size +
            "&page_id=" +
            $scope.meta.page_id;
        if ($scope.filter["status"]) {
            url += "&payment_status=" + $scope.filter["status"];
        }
        if ($scope.filter["weekly_payment_status"]) {
            url += "&weekly_payment_status=" + $scope.filter["weekly_payment_status"];
        }
        if ($scope.filter["dateFrom"]) {
            url +=
                "&date_from=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateFrom);
        }
        if ($scope.filter["dateTo"]) {
            url +=
                "&date_to=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateTo);
        }
        if ($scope.filterWeek["weekStartDate"]) {
            url +=
                "&week_start_date=" +
                $scope.vietnameseTimeToSQLTime($scope.filterWeek.weekStartDate);
        }
        if ($scope.filterWeek["weekEndDate"]) {
            url +=
                "&week_end_date=" +
                $scope.vietnameseTimeToSQLTime($scope.filterWeek.weekEndDate);
        }
        if ($scope.filterWeek["weekly"]) {
            url += "&weekly=" + $scope.filterWeek.weekly;
        }
        return url;
    };

    $scope.exportExcel = () => {
        $scope.filterWeek.weekly = null;
        let url = buildUrl();
        url += '&export_excel=1'
        window.location.href = url;
    }

    $scope.exportExcelWeekly = () => {
        $scope.filterWeek.weekly = 1;
        let url = buildUrl();
        url += '&export_excel=1'
        window.location.href = url;
    }

    $scope.clear = () => {
        $scope.filter = {
            status : "PENDING",
            dateFrom : "",
            dateTo : "",
        };
        
        $scope.find(); 
    };

    $scope.clearWeek = () => {
        $scope.filterWeek = {
            weekStartDate : "",
            weekEndDate : ""
        }
        $scope.findWeek(); 
    };

    $scope.next = function () {
        if ($scope.increasePageId()) {
            if (!isMonthly) {
                $scope.findWeek(); 
            } else {
                $scope.find();
            }
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            if (!isMonthly) {
                $scope.findWeek(); 
            } else {
                $scope.find();
            }
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            if (!isMonthly) {
                $scope.findWeek(); 
            } else {
                $scope.find();
            }
        }
    };

    $scope.checkAllInvoice = function () {
        $scope.invoices.forEach(invoice => {
            invoice.is_checked = $scope.checkAll;
        });
        if ($scope.checkAll) {
            $scope.totalInvoiceSelected = $scope.invoices.length;
        } else {
            $scope.totalInvoiceSelected = 0;
        }
    }


    $scope.checkOneInvoice = function () {
        var checkAll = true;
        $scope.totalInvoiceSelected = 0;
        $scope.invoices.forEach(invoice => {
            if (!invoice.is_checked) {
                checkAll = false;
            } else {
                $scope.totalInvoiceSelected++
            }
             
        });
        $scope.checkAll = checkAll;
    }

    $scope.bulkChangePaymentStatus = function (status) {
        if (confirm("Are you sure to change payment status to " + status)) {
            $scope.invoices.forEach(invoice => {
                if (invoice.is_checked && invoice.payment_status != status) {
                    $scope.callApiUpdateInvoice(invoice, 'payment_status', status, false);
                }
            });
           setTimeout(() => {
                $scope.find();
           }, 1000);
        }
    }

    $scope.initalize();
}
