system.controller("SellerRevenueController", SellerRevenueController);
function SellerRevenueController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );
    $scope.filter = {
        dateTo: moment().format('DD/MM/YYYY'),
        dateFrom: moment().subtract(6, 'days').format('DD/MM/YYYY')
    };
    $scope.statuses = [
        {
            code: 'all',
            name: 'All status'
        },
        {
            code: 'PENDING',
            name: 'Pending'
        },
        {
            code: 'AVAILABLE',
            name: 'Available'
        },
        {
            code: 'CANCELED',
            name: 'Canceled'
        },
        {
            code: 'Paid',
            name: 'Paid'
        }
    ];
    $scope.detailFilter = {
        status: 'all'
    };
    
    $scope.items = [];
    $scope.dates = [];
    $scope.currentItem = {};

    $scope.initalize = () => {
        $scope.getRevenue(1);
    }
    $scope.find = () => {
        $scope.getRevenue(1);
    }
    $scope.changePage = function (page) {
        if ($scope.getRevenue(page)) {
            $scope.find();
        }
    };
    $scope.getRevenue = (page) => {
        $scope.loading = true;
        url = `/module/seller/revenue/statistic?page_id=${page}`;
        url = $scope.buildUrl(url);
        $http.get(url).then((response) => {
            $scope.items = response.data.result;
            $scope.meta = response.data.meta;
            $scope.loading = false;
            
        });
    }

    $scope.getIndexNo = (index) => {
        if ($scope.meta.page_size && $scope.meta.page_id) {
            return $scope.meta.page_size * ($scope.meta.page_id) + index + 1;
        } else {
            return index + 1;
        }
    }

    $scope.buildUrl = function (url) {
        if ($scope.filter.email) {
            url += `&email=${$scope.filter.email}`;
        }
        if ($scope.filter.dateFrom) {
            url += `&dateFrom=${$scope.filter.dateFrom}`;
        }
        if ($scope.filter.dateTo) {
            url += `&dateTo=${$scope.filter.dateTo}`;
        }
        return url;
    }

    $scope.clear = function () {
        $scope.filter = {};
        $scope.find();
    }


    $scope.showRevenueDetail = (item) => {
        $scope.currentItem = angular.copy(item);
        $('#revenue-detail').modal('show');
        $scope.getRevenueBySeller();
    }

    $scope.getRevenueBySeller = () => {
        var seller_token = $scope.currentItem.seller_token;
        $scope.loading = true;
        url = `/module/seller/revenue/statistic/${seller_token}?dateFrom=${$scope.filter.dateFrom}&dateTo=${$scope.filter.dateTo}&status=${$scope.detailFilter.status}`;
        url = $scope.buildUrl(url);
        $http.get(url).then((response) => {
            $scope.currentItem.revenues = response.data.result;
            $scope.loading = false;
        });
    }
 
    $scope.initalize();
}
