system.controller("NewProductEveryDayController", NewProductEveryDayController);
function NewProductEveryDayController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );
    $scope.filter = {
        dateTo: moment().format('DD/MM/YYYY'),
        dateFrom: moment().subtract(6, 'days').format('DD/MM/YYYY')
    };
    $scope.items = [];
    $scope.dates = [];

    $scope.initalize = () => {
        $scope.getNewProductEveryDay(1);
    }
    $scope.find = () => {
        $scope.getNewProductEveryDay(1);
    }
    $scope.changePage = function (page) {
        if ($scope.getNewProductEveryDay(page)) {
            $scope.find();
        }
    };
    $scope.getNewProductEveryDay = (page) => {
        $scope.loading = true;
        url = `/module/seller/seller-statistic/new-product-every-day?page_id=${page}`;
        url = $scope.buildUrl(url);
        $http.get(url).then((response) => {
            $scope.items = response.data.result;
            $scope.dates = response.data.dates;
            $scope.loading = false;
            $scope.meta = response.data.meta;
        });
    }

    $scope.buildUrl = function (url) {
        if ($scope.filter.email) {
            url += `&email=${$scope.filter.email}`;
        }
        if ($scope.filter.dateFrom) {
            url += `&dateFrom=${$scope.filter.dateFrom}`;
        }
        if ($scope.filter.dateTo) {
            url += `&dateTo=${$scope.filter.dateTo}`;
        }
        return url;
    }

    $scope.clear = function () {
        $scope.filter = {};
        $scope.find();
    }
 
    $scope.initalize();
}
