$(document).ready(function(){
    $('#see-full').click(function () {
        $('body').addClass('open-popup')
    })
    $('#close-popup, .seller-popup-background').click(function () {
        $('body').removeClass('open-popup')
    })

    $(document).keyup(function(e) {
        if (e.which == 27) {
            $('body').removeClass('open-popup')
        }   // esc
    });

    $("#resgiter-account").click(function(){
        var email = $("#resgiter-email").val();
        var shopName = $("#resgiter-shopname").val();
        var password = $("#resgiter-password").val();
        var rePassword = $("#resgiter-repassword").val();
        var isReceiveArtistNew = $("#special-offers").val();
        var isValid = true;
        if( email ==''){
            $('#resgiter-email').addClass("error-required");
            $('#email-error').html(messages['required']['email']);
            $("#email-error").show();
            isValid = false;
        } else {
            let regex = new RegExp(/(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/);
            if (!regex.test(email)) {
                $('#email-error').html(messages['email']);
                $("#email-error").show();
                isValid = false;
            }
        }
        if( shopName == ''){
            $('#resgiter-shopname').addClass("error-required");
            $('#shopname-error').html(messages['required']['shop_name']);
            $("#shopname-error").show();
            isValid = false;
        }
        if( password == ''){
            $('#resgiter-password, #resgiter-repassword').addClass("error-required");
            $('#password-error').html(messages['required']['password']);
            $("#password-error").show();
            isValid = false;
        }
        if( rePassword == ''){
            $('#resgiter-password, #resgiter-repassword').addClass("error-required");
            $('#repeat-password-error').html(messages['required']['repeat_password']);
            $("#repeat-password-error").show();
            isValid = false;
        }
        if (password != '' && rePassword != '' && password != rePassword) {
            $('#repeat-password-error').html(messages['match_password']);
            $("#repeat-password-error").show();
            isValid = false;
        }
        if (isValid) {
            var url = sellerUrl + "/api/seller/register"
            var regParams = {
                url: url,
                method: 'POST',
                data: {
                    email: email,
                    shop_name: shopName,
                    password: password,
                    is_receive_artist_new: isReceiveArtistNew,
                    locale: locale
                }
            };
            $.ajax(regParams).done(function(response) {
                if (response.status == 'successful') {
                    $("#register-success").show();
                    $("#resgiter-area").hide();
                } else {
                    $("#register-error > .error-message").html(response.message);
                    $("#register-error").show();
                }
            });
        }
    });

    $("#resgiter-email, #resgiter-shopname, #resgiter-password, #resgiter-repassword").keyup(function(e) {
        $('#resgiter-email, #resgiter-shopname, #resgiter-password, #resgiter-repassword').removeClass("error-required");
        $("#email-error, #shopname-error, #password-error, #repeat-password-error, #register-error").hide();
    });
});
