system.controller("SellerAdvertisedProductController", SellerAdvertisedProductController);
function SellerAdvertisedProductController($scope, $http, $rootScope, Upload) {
    
    $scope.states = {
        isLoading: true
    }
    $scope.productPagination = {
        number_page: 1,
        current_page: 1,
        page_size: 50
    };
    $scope.sellers = [];
    $scope.filters = {
        sellerId: '',
        status: ''
    };
    $scope.allStatus = [];
    $scope.selectedProductIds = {};
    $scope.selectAllProduct = false;

    $scope.changeSellerFilter = () => {
        getSellers();
        getProducts();
        countSellerProducts();
    }

    $scope.bulkApprovedProduct = () => {
        $http.put('/module/seller/seller-advertised-product/approve-product', {
            product_ids: getSelectedProductIds()
        }).then(() => 
        {
           $scope.getProducts();
        });
    }

    $scope.bulkRejectProduct = () => {
        $http.put('/module/seller/seller-advertised-product/reject-product', {
            product_ids: getSelectedProductIds()
        }).then(() => 
        {
           $scope.getProducts();
        });
    }

    $scope.approvedProduct = (product) => 
    {
        $http.put('/module/seller/seller-advertised-product/approve-product', {
            product_ids: [product.id]
        }).then(() => 
        {
           $scope.getProducts();
        });
    }

    $scope.rejectProduct = (product) => {
        $http.put('/module/seller/seller-advertised-product/reject-product', {
            product_ids: [product.id]
        }).then(() => 
        {
           $scope.getProducts();
        });
    }

    function countSellerProducts()
    {
        $scope.sellerProductCount = null;

        if ($scope.filters.sellerId)
        {
            $http.get('/module/seller/seller-advertised-product/count-seller-products?sellerId=' + $scope.filters.sellerId).then((response) => 
            {
                $scope.sellerProductCount = response.data;
            });
        }
    }

    function getSellers()
    {
        const statusFilter = {};
        if ($scope.filters.status) {
            statusFilter.status = $scope.filters.status;
        }
        const params = new URLSearchParams(statusFilter).toString();

        $http.get('/module/seller/seller-advertised-product/get-sellers?' + params).then((response) => 
        {
            $scope.sellers = response.data;
        });
    }

    function getProducts()
    {
        $scope.states.isLoading = true;

        $scope.selectAllProduct = false;
        $scope.selectedProductIds = {};
    
        const filters = {
            sellerId: $scope.filters.sellerId,
            status: $scope.filters.status,
            page: $scope.productPagination.current_page
        }
        
        const params = new URLSearchParams(filters).toString();

        $http.get('/module/seller/seller-advertised-product/get-product?' + params).then((response) => 
        {
            $scope.products = response.data.data;

            $scope.productPagination.number_page = response.data.last_page;
            $scope.productPagination.page_size = response.data.per_page;

            $scope.states.isLoading = false;
        });
    }
    
    $scope.getProducts = getProducts;

    $scope.range = function (min, max, step) {
        step = step || 1;
        var input = [];
        for (var i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    $scope.changeCheckAll = function() {
        const productIds  = {};
        let status = false;

        if ($scope.selectAllProduct) {
            status = true;
        }

        for (let i = 0; i < $scope.products.length; i++) {
            productIds[$scope.products[i].id] = status;
        }

        $scope.selectedProductIds = productIds;

        $scope.changeProductSelection();
    }

    $scope.changeProductSelection = function() {

        const selectedLength = getSelectedProductIds().length;

        if (selectedLength < $scope.products.length) {
            $scope.selectAllProduct = false;
        }

        if (selectedLength) {
            $scope.showBulkAction = true;
        } else {
            $scope.showBulkAction = false;
        }
    }

    const initalize = () => {
        getSellers();
        getProducts();
    }

    const getSelectedProductIds = () => {
        const ids = [];
        for (const key in $scope.selectedProductIds) {
            if (Object.hasOwnProperty.call($scope.selectedProductIds, key)) {
                if ($scope.selectedProductIds[key]) ids.push(key);
            }
        }
        return ids;
    }

    initalize();
}
