system.controller("SellersController", SellersController);
function SellersController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController(
        $scope,
        $http,
        $rootScope,
        Upload
    );
    $scope.sellers = [];
    $scope.filter = {
        shopName: "",
        dateFrom: "",
        dateTo: "",
        order: {
            key: "total_revenue",
            type: "desc",
        },
        status: ''
    };
    $scope.allStatus = [];

    $scope.statuses = {
        '': 'Choose status',
        'ACTIVE': 'ACTIVE', 
        'PENDING': 'PENDING',
        'SUSPENDED': 'SUSPENDED'
    }

    $scope.statusesToChange = [
        'ACTIVE', 
        'PENDING',
        'SUSPENDED'
    ]
    $scope.sellerSuspend = null;
    $scope.noteSuspend = null;
    $scope.errors = {};
    $scope.indexElementChangeStatus = null;
    $scope.sellersCopy = [];
    $scope.loading = false;
    $scope.filterForm = {
        keyword: "",
        status: ''
    };
    $scope.initalize = () => {
        $("#date-from").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "-4w");

        $("#date-to").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "+0");
        $scope.getSeller();   
    }
    $scope.find = () => {
        $scope.getSeller();
    }
    $scope.getSeller = () => {
        const url = buildUrl();
        fetch(url)
            .then((response) => response.json())
            .then((data) => {
                if (data.status == "successful") {
                    $scope.$applyAsync(() => {
                        $scope.sellers = data.result; 
                        $scope.sellersCopy = angular.copy($scope.sellers);
                        $scope.meta = data.meta;
                    });
                }
            });

    }
    const buildUrl = () => {
        let url =
            "/service/seller/find" +
            "?page_size=" +
            $scope.meta.page_size +
            "&page_id=" +
            $scope.meta.page_id;
        if ($scope.filter['status']) {
            url += '&status=' + $scope.filter['status'];
        }
        if ($scope.filter["dateFrom"]) {
            url +=
                "&date_from=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateFrom);
        }
        if ($scope.filter["dateTo"]) {
            url +=
                "&date_to=" +
                $scope.vietnameseTimeToSQLTime($scope.filter.dateTo);
        }
        if ($scope.filter['shopName']) {
            url += '&search=' + $scope.filter['shopName'];
        }
        if ($scope.filter['order']) {
            url += '&order_by=' + $scope.filter['order'].key;
            url += '&order_type=' + $scope.filter['order'].type;
        }
        return url;
    };
    $scope.sort = (key, type) => {
        $scope.filter['order'] = {
            key, type
        };
        $scope.find();
    }

    $scope.clear = () => {
        $scope.sellers = [];
        $scope.filter = {
            shopName: "",
            dateFrom: "",
            dateTo: "",
            order: {
                key: "total_revenue",
                type: "desc",
            },
            status: 'ACTIVE'
        };
        $scope.find();
    };
    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.goToSellerProducts = (token) => {
        let sellerId = null;
        $http.get (baseApiUrl + '/users?filters=seller_token=' + token).then((res) => {
                if (res.data.status == 'successful') {
                    sellerId = res.data.result[0].id;
                    if (sellerId) {
                        window.location.href = 
                            prefixLocaleUrl + "admin/products?seller_id=" + sellerId
                        ;
                    }
                }
        })
    };

    $scope.goToSellerOrders = (token) => {
        let sellerId = null;
        $http
            .get(baseApiUrl + "/users?filters=seller_token=" + token)
            .then((res) => {
                if (res.data.status == "successful") {
                    sellerId = res.data.result[0].id;
                    if (sellerId) {
                        window.location.href =
                            prefixLocaleUrl +
                                "admin/orders?seller_id=" +
                                sellerId
                        ;
                    }
                }
            });
        
    }; 

    $scope.openFormSeller = async (seller) => {
        $scope.orders = [];
        $scope.seller = {};
        $scope.report = {};
        await Promise.all([
            $scope.getSellerInfo(seller),
            $scope.statisticRevenue(seller),
        ]);
        $('.seller-popup-wrapper').addClass('active');
        $('body').addClass('open-seller-detail-pop');
    }

    $scope.getSellerInfo = async (seller) => {
        $scope.loading = true;
        let url = baseApiUrl + "/v2/order-seller";
        url = $scope.buildUrlForm(url, seller);
        await $http.get(url)
            .then((res) => {
                if (res.data.status == "successful") {
                    $scope.orders = res.data.result;
                    $scope.seller = res.data.user;
                    // $scope.report = res.data.user.report;
                    $scope.getRevenueBySeller(seller)
                }
                $scope.loading = false;
            }, function error() {
                console.log(error);
                $scope.loading = false;
            });
    }

    $scope.statisticRevenue = (seller) => {
        let url = "/service/seller/statistic-revenue";
        url += "?email=" + seller.email;
        $http.get(url)
            .then((res) => {
                if (res.data.status == "success") {
                    $scope.report = res.data.result;
                }
            });
    }

    $scope.getRevenueBySeller = function (seller) {
        if ($scope.orders.length == 0) {
            return;
        }
        var orderIds = $scope.orders.map(order => order.id);
        var url = "/service/seller/get-revenue";
        url += "?order_ids=" + orderIds.join(",");
        url += "&email=" + seller.email;
        $http.get(url).then(function success(response) {
            if (response.data.status == "success") {
                var revenues = response.data.result;
                if (revenues) {
                    $scope.orders.forEach(order => {
                        var revenue = revenues[order.id] ?? null;
                        if (revenue) {
                            order.revenue = revenue.revenue;
                            order.payment = revenue.payment;
                            order.payment_status = revenue.status;
                            order.available_date = revenue.available_date;
                        }
                    });
                }
            }
        });
    }

    $scope.buildUrlForm = (url, seller, exportExcel = false) => {
        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();
        if (!dateFrom || dateFrom == '') {
            alert('Please choose date from.');
            return;
        }
        if (!dateTo || dateTo == '') {
            alert('Please choose date to.');
            return;
        }
        url += "?filters=order.created_at=[" + dateFrom + " 00:00:00;" + dateTo + " 23:59:59]";
        if ($scope.filterForm.status) {
            url += ",order.status=" + $scope.filterForm.status;
        }
        if ($scope.filterForm.keyword) {
            url += "&keyword=" + $scope.filterForm.keyword;
        }
        url += "&seller_id=" + seller.id;
        if (exportExcel) {
            url += "&export_excel=1";
        }
        return url;
    }

    $scope.exportExcel = (seller) => {
        let url = baseApiUrl + "/v2/order-seller";
        window.open($scope.buildUrlForm(url, seller, true), '_blank');
    }

    $scope.resetFilter = (seller) => {
        $scope.filterForm.keyword = "";
        $scope.filterForm.status = "";
        $("#date-from").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "-4w");

        $("#date-to").datepicker({
            dateFormat: "yy-mm-dd",
        }).datepicker("setDate", "+0");
        $scope.getSellerInfo(seller);
    }

    $scope.closeFormSeller = () => {
        $('body').removeClass('open-seller-detail-pop');
        $('.seller-popup-wrapper').removeClass('active');
    }

    $scope.formatPrice = function (price, order) {
        template = currencyTemplate ? currencyTemplate : '${money}{.}{2}';
        if (order && order.currency && order.currency.template) {
            template = order.currency.template;
        }
        let matches = template.match(/{money}{([^a-zA-z0-9]+)}{([0-9]+)}/);
        if (matches.length > 2) {
            let separate = matches[1];
            let number = parseInt(matches[2]);
            template = template.replace(/{([^a-zA-z0-9]+)}/, '');
            template = template.replace(/{([0-9]+)}/, '');
            let decimal = separate == '.' ? ',' : '.';
            retval = template.replace('{money}', $scope.formatCurrency(price, separate, decimal, number));
        }

        return retval;
    }

    $scope.summarizeDateTime = function (dateTime, withYear) {
        if (dateTime != null) {
            var outputFormat = "$3/$2";
            if (withYear) {
                outputFormat += "/$1";
            }
            outputFormat += " $4:$5";
            return dateTime.replace(/(\d{4})-(\d{2})-(\d{2})\s+(\d{1,2}):(\d{1,2}):.*/, outputFormat);
        }
    };

    $scope.changeStatus = function (seller, index, isSuspend = false) {
        removeErrors();
        var param = {
            title: 'Change seller status',
            customText: 'Do you want to change seller status to ' + seller.status + '?',
        };

        if (seller.status == $scope.statuses.SUSPENDED) {
            $scope.indexElementChangeStatus = index;
            $scope.openModal();
            if (!isSuspend) {
                $scope.sellerSuspend = seller;
                return;
            }

            changeStatus(seller, index);
        } else {
            $scope.callConfirmModal(param, function() {
                $http({
                    method: 'patch',
                    url: '/service/seller/change-status/' + seller.id,
                    data: {'status': seller.status}
                }).then(function success(response) {
                    if (response.data.status == 'successful') {
                        if (seller.status.toUpperCase() != "ACTIVE") {
                            $http({
                                method: 'PUT',
                                url: sellerUrl + '/suspend',
                                data: {
                                    email: seller.email
                                }
                            })
                        }
                        toastr.success('Change status successful');
                    } else {
                        $scope.$apply(function () {
                            seller.status = seller.status == 'ACTIVE' ? 'PENDING' : 'ACTIVE';
                        })
                        toastr.error('Change status failed');
                    }
                });
            }, function () {
                $scope.$apply(function () {
                    seller.status = seller.status == 'ACTIVE' ? 'PENDING' : 'ACTIVE';
                })
            });
        }

    }

    function removeErrors(){
        $scope.errors = {};
    }

    function changeStatus(seller, index) {
        $http({
            method: 'patch',
            url: '/service/seller/change-status/' + seller.id,
            data: {
                'status': seller.status,
                'note': $scope.noteSuspend
            }
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                $scope.closeModal();
                $scope.noteSuspend = null;
                toastr.success('Change status successful');
            } else {
                $scope.errors = (response.data.errors);
                toastr.error('Change status failed');
            }
        });
    }

    $scope.cancelChangeStatus = (seller, index) => {
        seller.status = $scope.sellersCopy[index].status;
        removeErrors();
    }

    $scope.openModal = () => {
        $('#modal-confirm-suspend').modal('show');
    }
    
    $scope.closeModal = () => {
        $('#modal-confirm-suspend').modal('hide');
    }

    $scope.initalize();
}
