system.controller("SellerProductCommissionController", SellerProductCommissionController);
function SellerProductCommissionController($scope, $http, $rootScope, Upload) {
    
    $scope.states = {
        isLoading: true
    }

    $scope.configs = [];
    $scope.categories = [];
    $scope.selectedCategoryIds = [];
    $scope.commissionValue = 0;

    $scope.saveCommission = () => 
    {
        if ($scope.selectedCategoryIds.length) {
            $scope.states.isLoading = false;
            $http.post('/module/seller/seller-advertised-product/commission', {
                category_ids: $scope.selectedCategoryIds,
                commission: $scope.commissionValue
            }).then(function (response) {
                $('#configCommissionModal').modal('hide');
                getCommissionConfig();
            });
        }
    }

    $scope.safeApply = function(call = null) {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply(call);
        }
    }

    const getCommissionConfig = () =>
    {
        $http.get('/module/seller/seller-advertised-product/commission')
            .then(function (response) {
                $scope.configs = response.data;
                $scope.states.isLoading = false;
            });
    }

    const getCategories = () => {
        $http.get(baseApiUrl + '/categories')
            .then(function (response) {
                $scope.categories = response.data.result;
            });
    };

    const initalize = () => {
        getCategories();
        getCommissionConfig();

        $('#configCommissionModal').on('hidden.bs.modal', function (e) {
            $scope.selectedCategoryIds = [];
            $scope.commissionValue = 0;

            $scope.safeApply();
        })

    }

    initalize();
}
