@extends('layouts.master')

@section('css')
<link rel="stylesheet" href="{{ asset('modules/seller/css/selling.css?v=' . config('sa.version')) }}">
@endsection
@section('main')
<?php
$sellerUrl = config('seller::sa.seller_url');
$locale = env('APP_LOCALE', '');
if (!$locale) {
    $locale = 'us';
}
if ($locale != '' && $locale != 'us') {
    $sellerDomain = config('seller::sa.seller_domain', 'seller.printerval.com');
    $sellerUrl = 'https://' . $locale . '.' . $sellerDomain;
}
$linkVideo = getOption('seller_page.youtube_video', 'https://www.youtube.com/embed/hoUviS2SBic');
$fees = [
    'listing_fee' => ['id' => '1', 'price' => config('seller::fee.seller_fee.' . $locale . '.listing_fee', 0.2), 'display_price' => formatPrice(config('seller::fee.seller_fee.' . $locale . '.listing_fee', 0.2))],
    'transaction_fee_percent' => config('seller::fee.seller_fee.' . $locale . '.transaction_fee_percent', '6.5%'),
    'payment_process_fee_percent' => config('seller::fee.seller_fee.' . $locale . '.payment_process_fee_percent', '4%'),
    'payment_process_fee' => ['id' => '2', 'price' => config('seller::fee.seller_fee.' . $locale . '.payment_process_fee', 0.25), 'display_price' => formatPrice(config('seller::fee.seller_fee.' . $locale . '.payment_process_fee', 0.25))],
    'offsite_ads_fee' => config('seller::fee.seller_fee.' . $locale . '.offsite_ads_fee', '15%'),
];

priceChangeDecor($fees);
?>
<main class="selling-page">
    <div class="selling-top" style="background-image: url({{'/modules/seller/images/' . env('APP_NAME') .'/selling-background.jpg?v=' . config('sa.version')}});">
        {{ __('Millions of shoppers can\'t wait to see what you have in store') }}
    </div>
    <div class="selling-content creativity-box">
        <div class="site-w">
            <h1 class="selling-header">
                {{ __('Creativity. Community. And sweet, sweet cash.') }}
            </h1>
            <div class="selling-description">
                {{ __('Sell your art printed on high-quality products to a global audience. It’s fun, easy, and quick to get started.') }}
            </div>
            <a href="{{ $sellerUrl }}/register{{ strpos(url()->full(), '?') !== false ? substr(url()->full(), strpos(url()->full(), '?')) : '' }}" class="selling-button button secondary" target="_blank">
                {{ __('Start selling') }}
            </a>
        </div>
    </div>
    @if(false)
    <div class="selling-content find-fans">
        <div class="site-w flex-b flex-s align-c flex-w">
            <div class="fin-fans-left">
                <h2 class="selling-header">
                    {{ __('Find your fans') }}
                </h2>
                <div class="selling-description">
                    <?= sprintf( __('Create what you love, and connect with people who love it, too. From Boston to Bangkok, millions of visitors come to %s looking for their weirdly meaningful thing.'), config('app.name')) ?>
                </div>
            </div>
            <div class="fin-fans-right video-contain">
                <iframe width="560" height="365" src="{{ getOption('seller_page.youtube_video', 'https://www.youtube.com/embed/hoUviS2SBic') }}?rel=0&controls=0&showinfo=0&amp;modestbranding=1&fs=0 " title="{{ sprintf(__('%s - What makes us, us'), config('app.name')) }}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
        <div class="ragged-edge-container fill-grace-pink">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1400 60" preserveAspectRatio="none">
                <path d="M1400 0H0v44l10 1 77-11 98 11 82-10 160 10 209-9 172 24 295-12 251 9 46-8z"></path>
            </svg>
        </div>
    </div>
    @endif
    <div class="selling-content how-works">
        <div class="site-w">
            <h2 class="selling-header">
                <?= sprintf( __('How %s works'), config('app.name')) ?>
            </h2>
            <div class="selling-description flex-b flex-c">
                <div class="how-works-item">
                    <picture>
                        <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.upload', asset('modules/seller/images/' . env('APP_NAME') .'/upload.svg')) }}" />
                        <source src="/images/blank.gif" />
                        <img src="/images/blank.gif" alt="{{ __('You upload your designs to products in your shop') }}" loading="lazy" width="170" height="170" />
                    </picture>
                    <p>{{ __('You upload your designs to products in your shop') }}</p>
                </div>
                <div class="how-works-item">
                    <picture>
                        <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.customers', asset('modules/seller/images/' . env('APP_NAME') .'/customers.svg')) }}" />
                        <source src="/images/blank.gif" />
                        <img src="/images/blank.gif" alt="{{ __('Customers find and purchase products they love, featuring your designs') }}" loading="lazy" width="170" height="170" />
                    </picture>
                    <p>{{ __('Customers find and purchase products they love, featuring your designs') }}</p>
                </div>
                <div class="how-works-item">
                    <picture>
                        <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.products', asset('modules/seller/images/' . env('APP_NAME') .'/products.svg')) }}" />
                        <source src="/images/blank.gif" />
                        <img src="/images/blank.gif" alt="{{ __('Products are produced to order and shipped around the world') }}" loading="lazy" width="170" height="170" />
                    </picture>
                    <p>{{ __('Products are produced to order and shipped around the world') }}</p>
                </div>
                <div class="how-works-item">
                    <picture>
                        <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.paid', asset('modules/seller/images/' . env('APP_NAME') .'/paid.svg')) }}" />
                        <source src="/images/blank.gif" />
                        <img src="/images/blank.gif" alt="{{ __('Customers get an awesome product, and you get paid') }}" loading="lazy" width="170" height="170" />
                    </picture>
                    <p>{{ __('Customers get an awesome product, and you get paid') }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="selling-content your-art">
        <div class="inline-art">
            <img src="{{ asset('modules/seller/images/your-art.svg') }}" loading="lazy" alt="">
        </div>
        <div class="your-art-content">
            <div class="site-w flex-b align-c flex-s flex-w">
                <div class="fin-fans-left">
                    <img src="{{ getOption('seller_page.your_art', asset('modules/seller/images/' . env('APP_NAME') .'/your-art.png?v=' . config('sa.version'))) }}" loading="lazy" alt="{{ __('Your art on over 70 unique products') }}" width="646">
                </div>
                <div class="fin-fans-right">
                    <h2 class="selling-header">
                        {{ __('Your art on over 70 unique products') }}
                    </h2>
                    <div class="selling-description">
                        {{ __('From t-shirts to masks to mugs, your designs will be printed one at a time by third-party producers on high-quality products. And printing to order means less waste, which is better for the planet.') }}
                    </div>
                </div>
            </div>
        </div>
        <div class="inline-art rotate">
            <img src="{{ asset('modules/seller/images/your-art.svg') }}" loading="lazy" alt="{{ __('Your art on over 70 unique products') }}">
        </div>
    </div>
    <div class="selling-content successful-artists">
        <div class="site-w flex-b align-c flex-s flex-w">
            <div class="fin-fans-left">
                <h2 class="selling-header">
                    {{ __('Join thousands of successful artists') }}
                </h2>
                <div class="selling-description">
                    <?= sprintf( __('Artists are the heart of the %s marketplace. From the pro, to the hobbyist, to the fan with a great idea, thousands of creators are earning money on %s every day. Here are just a few of them.'), config('app.name'), config('app.name')) ?>
                </div>
                <a class="view-shops is-desktop" href="{{ clroute('/shops') }}">
                    {{ __('View shop') }}
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                    </svg>
                </a>
            </div>
            <div class="fin-fans-right">
                <img src="{{ getOption('seller_page.artists', asset('modules/seller/images/' . env('APP_NAME') .'/artists.png?v=' . config('sa.version'))) }}" loading="lazy" alt="{{ __('Join thousands of successful artists') }}">
                <a class="view-shops is-mobile" href="{{ clroute('/shops') }}">
                    {{ __('View shop') }}
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                    </svg>
                </a>
            </div>
        </div>
    </div>
    <div class="selling-content simple-wrapper" >
        <span class="inline-svg"><svg xmlns="http://www.w3.org/2000/svg" class="wt-fill-denim-tint wt-width-full" viewBox="0 0 1280 30" preserveAspectRatio="xMidYMid slice" aria-hidden="true" focusable="false"><path d="M1280 30h-8.1c-5.7 0-37-10.9-37.4-10.7-2.2 1.2-17.6-.8-19.9-4.1 0 0-9.8-3.3-10.3-3.3-1.3 0-12.6 3-13 2.5-.7-.7-13.8-3.7-13.8-5.3-2.3 1.3-21.2-7.8-23.4-6.7-1-.8-2.2-1.5-3.3-2.4-1.8 1.9-3.3 3.4-4.7 4.9-2.7-.8-4.8-1.4-7.1-2.1-.5.1-1 .3-1.5.5-4 1.3-5.3 1-7.3-1.3-1.7-2.1-5.3-2.2-8.1-.8-2 1-4.6 2.6-6.5 2.3-4.5-.7-6 1.1-8.1 2.6-1.5 1.1-3.1 2.1-4.6 3.1-1.8-.8-3.5-1.2-5.3-2-.3.8-.7 1.3-.8 2-.5 0-.8 0-1.2-.1V3.5c-2 .8-3.5 1.2-4.8 1.8-1.3-.8-2.3-1.6-3.5-2.4-5.1 1.2-10.1 2-15.3.1-.8-.3-2.2-.3-3-.1-1.2.3-2.2 1-3.3 1.6-1.2-.3-2.3-.8-3.8-1.1-1.7 1.1-3 2.9-6.5 1.6-.8-.3-2.3.1-3.5.3-4 .8-7.8 1.4-11.9 2-1.5.2-3-.2-4.7-.3-1-.1-1.8-.2-2.8-.2-6-.3-11.8 2.3-17.8.1-.5-.2-1.3-.2-1.8-.1-3.8 1.6-8.3 1.2-12.5 1.3-1 0-2.2.5-3.1.9-1.8.8-9.5 1.5-11.5 1.1-4.5-.8-8.1-.3-10.1 2.3-12.8-1.6-12.8-1.6-17.1.9-2.3-.4-6-1.6-7.1-1.1-4.7 2.4-7 .2-9.8-1.4-5 1.1-10.8-.8-15.8 1.4-7.3-2.7-14.9-2.7-22.9-.2-5-3.7-9.6-3.8-13.8 0-.3-1.3-.7-2.5-1-3.8-3.3.8-6.1 1.1-8.6 1.8-2.7.7-6 2.3-7.5 1.9-4.2-1.3-5.3 1.8-9 1.4-1-.9-2.3-2.2-4-3.5-1.3.3-2.8.7-4 1-3.5 1.1-6.8 2-10.3 0-.5-.3-1.8-.2-2.8-.1-2.5.2-4.8.7-7.5.9-.8.9-1.7 1.9-2.3 2.9-8.5-1.1-16.4-2.6-24.7-.4-.3.1-1.2-.1-1.7-.3-2.3-1.2-3.7-.3-5.1.8-1.2.7-2.7 1.8-4 1.8-7.3.2-14.8-.4-22.1.3-3 .3-6.8-.3-9 .7-3.3 1.5-6 .9-9.1.5-2.7-.4-5-.9-7.1-2.1-2-1-4.3-.5-4.6 1.1-.3 1.5-1.8 2.3-3.7 2.1-3.3-.8-6.8-.3-10-1.8-4.8-2.1-10.6-2.7-16.3-.7-1.7.7-3.3 1-5 1.6-.3.1-.8.1-1.5.1-1.2-.7-2.3-1.2-3.5-1.9-2 1.8-4.6 1.8-7.1.9-2.8-.8-5.6-1.3-8.8-.9-2.7.3-5.5.5-8.3.7-2 .1-4.5.8-5.8-.9-.2-.3-1.5-.4-2.2-.3-3.7.7-7.3 1.5-11 2.2-.2-.3-.5-.5-.5-.7-.2-.3-.2-.8-.2-.8-1.8.5-3.7 1.2-5.6 1.4-1.8.2-4.7-.7-5.8-.1-3.8 1.9-8.1 1.2-12.3 1.9-2.2-2.5-2.2-2.5-5.8-.9-.7.3-1.5.5-2.3.5-3-.1-6.1-.2-9.1-.5-2.7-.3-5.6-.5-7.6-1.4s-3.8-1.3-6.1-1.2c-4.6.2-9.3.3-13.9.5-4.3.2-8.6.4-14.3.8-1.7-.5-4.7-1.2-7.5-2.2-3.7-1.4-7.1-1.4-10.8.1-1.7.7-4.5 1.6-5.5 1.2-3.3-1.4-1.7 1.3-3 1.1-1.8-.3-3.7-.9-5.1-.7-3.7.4-7.1-.2-10.8-.1-5 .1-10 0-11.6 4.1-5-2.4-9.1-1-13 .5-1.3-.8-2.2-1.4-2.8-1.9-1.7.5-3 1.3-4.2 1.1-2.7-.3-5-1.1-7.3-1.8-1 .4-2 1-3 1.1-5.1.4-10.3.4-15.3.9-2 .2-5-.5-6.6 1.1-.3.3-2.8.4-3.3 0-2.2-1.9-5.1-1.2-8-1-3.3.3-6.6.5-9.8-.7-1.5-.5-4-.8-5.3-.2-4.6 1.9-9.5 2.6-14.9 3.3-5.6.8-9.8-.5-13.9-2.2-1.7 1-3.3 1.6-5.5.4-4.8-3-10.1-2.1-15.6-.7-2.8-.8-5.5-3.3-9.6-1.2-5.6-.8-11.1-.7-16.4 1-.7.2-2 .1-2.3-.2-1.7-1-3.5-1.8-6-1.6-1.2-2.5-4-.9-6.1-.8-2.5 0-5.1 1-7.1.5-2.5-.7-5-.4-7.3-.8-2.8-.4-6 .8-9 .8-5.3.3-10 1.4-13.9 3.6-.8.4-1.7.9-2.5.9-3.8.3-7.6.7-11.5.4-3.7-.3-7.3-.7-11.1-.1-1 .1-2.3-.5-3.3-.9-2.5-1-4.8-1.9-8.1-1.1-2.2.4-4.2 0-3.8-1.8-2.3.1-5 .8-7.1.3-2-.4-3-.9-4.5.5-.7.5-3.2.1-4.6.5-4.2.9-8.1 2.4-12.3 3-2.2.3-5.5.3-7.5-1.3-3.5-2.6-5.3-2.4-11-.9-1.3.3-2.8.8-4.3.9-3.3.2-6.8.3-10.8.5-2-2.9-6-5.2-11.5-7v3.1c-4.5-3.8-10.8-3-16.1-4.4-4.5 1.8-9 3.4-14.6 5.5-5-1-9.6-3.1-15.3-1.2-1 .3-3.2.1-4-.4-3.2-1.9-7.5-1.9-11-3.2-4.2-1.6-8.8-2.9-13.3-4.2-1.2-.3-11.8 2.4-13 2.4-6.6 0-20.3 11.5-25.6 9.8-6.1-2-13 .2-20.1-1-8.1 2.3-15.3 7.2-19.8 7.7H0M172.9 20c.1 0 .3 0 0 0z"></path></svg></span>
        <div class="body-max-width-980" style="padding: 0 0 32px">
            <div class="selling-header">
                {{ __('Simple, transparent, secure') }}
            </div>
            <div class="selling-description">
                <div class="flex-b align-c">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="check-icon" viewBox="0 0 16 16"> <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/> </svg>
                    {{ __('No additional monthly fees')}}
                </div>
                <div class="flex-b align-c">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="check-icon" viewBox="0 0 16 16"> <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/> </svg>
                    {{ __('Secure transactions')}}
                </div>
                <div class="flex-b align-c">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="check-icon" viewBox="0 0 16 16"> <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/> </svg>
                    {{ __('Automatic deposits')}}
                </div>
                <div class="flex-b align-c">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="check-icon" viewBox="0 0 16 16"> <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z"/> </svg>
                    {{ __('Seller protection')}}
                </div>
            </div>
            <div class="selling-description-bottom">
                <div class="selling-description-item">
                    <span class="selling-description-bottom-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-layout-wtf" viewBox="0 0 16 16"> <path d="M5 1v8H1V1h4zM1 0a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V1a1 1 0 0 0-1-1H1zm13 2v5H9V2h5zM9 1a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9zM5 13v2H3v-2h2zm-2-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H3zm12-1v2H9v-2h6zm-6-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1H9z"/> </svg>
                    </span>
                    <div class="selling-description-bottom-content">
                        <h2 class="selling-header">
                            {{ __('No listing fee') }}
                        </h2>
                        <div>
                            {{ __('Listings are active for four months, or until they sell.')}}
                        </div>
                    </div>
                </div>

                <div class="selling-description-item selling-description-table-item">
                    <span class="selling-description-bottom-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5H0V4zm11.5 1a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-2zM0 11v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-1H0z"/> </svg>
                    </span>
                    <div class="selling-description-bottom-content">
                        <h2 class="selling-header selling-header-table">
                            {{ __('Competitive commission')}}
                        </h2>
                        <div>
                            <table class="c-payout-table">
                                <thead>
                                    <tr>
                                        <th header="true">{{ __('Product') }}</th>
                                        <th header="true">{{ __('Regular') }}</th>
                                        <th header="true">{{ __('Sale') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="c-payout-table__body">
                                        <td header="false" class="strong">{{ __('Male, Tri-Blend T-Shirt (Extra Soft)') }}</td>
                                        <td class="fw-bold" header="false">30%</td>
                                        <td header="false">25%</td>
                                    </tr>
                                    <tr class="c-payout-table__body">
                                        <td header="false" class="strong">{{ __('Male, Premium T-Shirt') }}</td>
                                        <td header="false">30%</td>
                                        <td header="false">25%</td>
                                    </tr>
                                    <tr class="c-payout-table__body">
                                        <td header="false" class="strong">{{ __('Male, V-Neck T-Shirt') }}</td>
                                        <td header="false">20%</td>
                                        <td header="false">15%</td>
                                    </tr>
                                    <tr class="c-payout-table__body">
                                        <td header="false" class="strong">{{ __('Male, Classic T-Shirt') }}</td>
                                        <td header="false">30%</td>
                                        <td header="false">25%</td>
                                    </tr>
                                    <tr class="c-payout-table__body">
                                        <td header="false" class="strong">{{ __('Male, Ringer T-Shirt') }}</td>
                                        <td header="false">20%</td>
                                        <td header="false">15%</td>
                                    </tr>
                                    <tr class="c-payout-table__cta">
                                        <td header="false" colspan="5">
                                            <a href="{{ asset('modules/seller/seller-commissions.pdf') }}" target="_blank" class="c-payout-table__btn-see-full">
                                                {{ __('See Full Chart') }}
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if(false)
        <div class="selling-content your-boss">
            <div class="site-w">
                <div class="payout-table-wrapper">
                    <h2 class="selling-header">
                        {{ __('The more creativeness, the more earnings') }}
                    </h2>
                    <div class="selling-description">
                        {{ sprintf(__('Every purchase made on %s contributes to your success as a self-employed artist!'), config('app.name')) }}
                    </div>
                    @php
                        $tShirt = config('seller::commission.7.config', []);
                        $rowLimit = 5;
                        $rowIndex = 0;
                    @endphp
                    <table>
                        <thead>
                        <th>
                            {{ __('Product') }}
                        </th>
                        <th>
                            {{ __('Regular') }}
                        </th>
                        <th>
                            {{ __('Sale') }}
                        </th>
                        </thead>
                        @foreach ($tShirt as $key => $value)
                            @if($key != 'default' && $rowIndex < $rowLimit)
                                <tr class="row-content">
                                    <td>
                                        {{ $value['name']}}
                                    </td>
                                    <td>
                                        {{ $value['regular'] }}%
                                    </td>
                                    <td>
                                        {{ $value['sale'] }}%
                                    </td>
                                </tr>
                            @endif
                            @php
                                $rowIndex++;
                            @endphp
                        @endforeach
                        <tfoot>
                        <td colspan="3">
                            <span id="see-full">
                                {{ __('See Full Chart') }}
                            </span>
                        </td>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="your-boss-bottom">
                <img src="{{ asset('modules/seller/images/sell-inverted-bottom.jpg') }}" alt="">
            </div>
        </div>
    @endif
    <div class="selling-content ready-wrapper">
        <div class="sppb-top-shape">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 80" preserveAspectRatio="none">
                    <path fill="#F8EBE6" d="M0,0V59.17c4.84-3,4.08,1,5.36-.23s0,0,2.57-1.27,3.08.51,7.19,1,2.83,2.54,2.83,2.54,8.74,5.08,10.28,4.57,4.88-9.14,4.37-10.15S40,61.22,40,61.22l4.37,3.3s9.76,2,11,1a59.11,59.11,0,0,1,8-4.57c1.8-.76,4.11,2.28,6.68,2.79s8.74,3.81,8.74,3.81S90.92,60.71,94,60.21s16.7,3.55,17.47,2,11.82-3,13.1-2.79,8.48,10.91,8.48,10.91l30.83-.51s6.68-6.09,7.45-7.61.26-1.78.26-1.78,9-4.57,10-4.57S193.18,61,193.18,61s10.54-4.06,14.39-5.08,6.68,1.52,12.85-2,19.79-2.79,20.56-3.3,7.45-6.34,12.85-9.39,11.31.76,13.1.76,7.71,5.33,10.79,4.57,10.28-5.33,13.62-5.33,2.83,2.28,10.28,1.78,5.91.51,12.59,4.32,8-2.29,12.85-3.55,1.8.25,4.63-.51a19,19,0,0,1,5.65-.76c1.29,0,2.57,1.52,8.74,3.55s5.91-.76,9.25-1.78,8.22-3.3,18.76-10.15,2.57,5.33,6.94,6.85,22.87,3.55,24.41,2,4.37-3,7.2-4.57,2.82-.51,3.59-.51,9,2.54,11.31,4.06,3.85,4.57,6.17,4.57,4.62-2.54,11-3.55-.26,4.82,0,5.58,2.06,0,5.4-.25,4.88-2.79,9.76-2.79,5.14,3.3,8.48,4.06,2.83,0,10.54-3.81,6.68-1.78,14.9-3.55,22.61,6.85,24.41,6.09,4.88-1.27,11.3-2.54,11.56,3,16.19,5.58,5.14-1.52,8.74-5.08,12.08.25,14.9.25,9.25-.25,13.36-.51,5.14-3,13.88-5.08,8,4.57,14.65,3.55,14.13-1.27,28-5.08,6.42,3,10.79,5.58,9,1.78,11.56,1.52S676,39.65,679.84,36.35s9.51,4.31,16.19,8.12,9.25,3.81,14.13,1.78,9.51-4.82,14.9-7.87,5.4,5.84,10,2.79,15.42.76,17.21-.25,8.48.76,15.42-1,1.8,2,7.45,6.85,3.08-2.29,15.42,1,28.52-2.29,32.89-3,4.88,5.33,9.25,5.84,5.4-4.82,9.76-7.87,17-.76,20.56-2a17.22,17.22,0,0,0,6.17-4.06s13.36,0,15.16-1.52,10.28-.76,13.36-.76,26,4.57,35.2,2.79,11.82-7.62,16.44-10.91,23.13,2.54,30.32,2.54,20.3-2.54,20.3-2.54V0Z"></path>
                </svg>
            </div>
        <h2 class="selling-header">
            {{ __('You\'re the boss') }}
        </h2>
        <div class="selling-description flex-b flex-c">
            <div class="how-works-item">
                <picture>
                    <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.complete_control', asset('modules/seller/images/' . env('APP_NAME') .'/complete-control.svg')) }}" />
                    <source src="/images/blank.gif" />
                    <img src="/images/blank.gif" alt="{{ __('Complete control over what you earn with flexible pricing') }}" loading="lazy" width="170" height="170" />
                </picture>
                <p>{{ __('Complete control over what you earn with flexible pricing') }}</p>
            </div>
            <div class="how-works-item">
                <picture>
                    <source media="(min-width: 320px)" srcset="{{ getOption('seller_page.anti_piracy', asset('modules/seller/images/' . env('APP_NAME') .'/anti-piracy.svg')) }}" />
                    <source src="/images/blank.gif" />
                    <img src="/images/blank.gif" alt="{{ __('Anti-piracy and watermark features to protect your designs') }}" loading="lazy" width="170" height="170" />
                </picture>
                <p>{{ __('Anti-piracy and watermark features to protect your designs') }}</p>
            </div>
            <div class="how-works-item">
                <picture>
                    <source media="(min-width: 320px)" srcset="{{   getOption('seller_page.world_class', asset('modules/seller/images/' . env('APP_NAME') .'/world-class.svg')) }}" />
                    <source src="/images/blank.gif" />
                    <img src="/images/blank.gif" alt="{{ __('Products are produced to order and shipped around the world') }}" loading="lazy" width="170" height="170" />
                </picture>
                <p>{{ __('Products are produced to order and shipped around the world') }}</p>
            </div>
        </div>
    </div>
    <div class="ragged-edge-container fill-grace-blue">
        <img src="{{ asset('modules/seller/images/ready.svg') }}" alt="">
    </div>
    <div class="site-w ready-start">
        <h3 class="selling-header">
            {{ __('Ready to start selling?') }}
        </h3>
        <div class="selling-description">
            <small>{{ __('In just a few minutes your shop can be open for business.') }}</small>
        </div>
        <a href="{{ $sellerUrl }}/register{{ strpos(url()->full(), '?') !== false ? substr(url()->full(), strpos(url()->full(), '?')) : '' }}" class="selling-button button secondary" target="_blank">
            {{ __('Start selling') }}
        </a>
    </div>
</main>
@include('seller::frontend.popup')
@endsection

@section('js')
<script src="{{ Module::asset('seller/js/seller.js?v=' . config('sa.version')) }}" charset=" utf-8"></script>
@endsection
