

<script>
    
    var app = angular.module('seller', ['ngFileUpload']);
    var messages = {
        required: {
            email: "{{ __('Please enter your email!') }}",
            shop_name: "{{ __('Please enter shop name!') }}",
            password: "{{ __('Please enter your password!') }}",
            repeat_password: "{{ __('Please enter repeat password!') }}",
        },
        email: "{{ __('Your email address is not valid!') }}",
        match_password: "{{ __('Repeat password is not match with your password!') }}",
        error: "{{ __('There was an error. Please try again later.') }}",
    }
    var locale = "{{$locale}}";
    toastr.options = {
        "autoDismiss": true,
        "preventDuplicates": true,
        "debug": false,
        "positionClass": "toast-bottom-right",
        "onclick": null,
        "fadeIn": 300,
        "fadeOut": 1000,
        "timeOut": 3000,
        "extendedTimeOut": 1000
    };

    app.controller('RegisterSellerController', function ($scope, $http, $rootScope, $sce, Upload) {
        $scope.seller = {};
        $scope.isLoading = false;
        $scope.init = function () {
            console.log(locale);
        }
        $scope.validate = function () {
            let retVal = true;
            $scope.message = {};
            if (retVal && !$scope.seller.email) {
                $scope.message["require_email"] = messages['required']['email'];
                retVal = false;
            }
            if (retVal) {
                let regex = new RegExp(/(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/);
                if (!regex.test($scope.seller.email)) {
                    $scope.message['email'] = messages['email'];;
                    retVal = false;
                }
            }
            if (retVal && !$scope.seller.shop_name) {
                $scope.message["shop_name"] = messages['required']['shop_name'];
                retVal = false;
            }
            if (retVal && !$scope.seller.password) {
                    $scope.message["password"] = messages['required']['password'];
                    retVal = false;
            }
            if (retVal && !$scope.seller.repeat_password) {
                $scope.message["repeat_password"] = messages['required']['repeat_password'];
                retVal = false;
            }

            if (retVal && $scope.seller.password != $scope.seller.repeat_password) {
                $scope.message["match_password"] = messages['match_password'];
                retVal = false;
            }
            return retVal;
        }

        $scope.save = function () {
            if ($scope.validate()) {
                let data = angular.copy($scope.seller);
                $http.post('/seller/register', data)
                    .then(function (response) {
                        console.log(response);
                        // toastr.success(messages['success']);
                    }, function (error) {
                        toastr.error(messages['error']);
                        $scope.isLoading = false;
                    });
            }
        }

        $scope.init();
    });
</script>
