@extends('layouts.master')
@section('css')
<link rel="stylesheet" href="{{ asset('modules/seller/css/selling.css?v=' . config('sa.version')) }}">
@section('main')
<?php
$locale = env('APP_LOCALE');
if (empty($locale)) {
    $locale = 'us';
}
$sellerUrl = config('seller::sa.seller_url');
$loginUrl = config('seller::sa.login_url');
?>
<main class="account-page">
    <div class="site-w">
        <fieldset id="account-resgiter" class="account-form active">
            <span class="account-form-image">
                <img src="{{ asset('modules/seller/images/signup.jpg') }}" alt="">
            </span>

            <div class="resgiter-message account-form-content" id="register-success" style="display: none;">
                <label class="account-heading">
                    {{ __('Register')}}
                </label>
                <div class="resgiter-successful">
                    <p>{{ __('Registration completed successfully.')}}</p>
                    <small>{{ __('We will get back to you in 48 working hours. Thank you for your patience.')}}</small>
                </div>
            </div>
            <form id="resgiter-area" class="account-form-content" method="post">
                <label class="account-heading">
                    {{ __('Register')}}
                </label>
                <div class="form-group">
                    <input id="resgiter-email" class="form-control" type="text" name="your-email" placeholder="{{ __('Your Email')}}" autocomplete="off">
                    <small class="error-message" style="display: none;" id="email-error"> </small>
                </div>
                <div class="form-group">
                    <input id="resgiter-shopname" class="form-control" type="text" name="your-name" placeholder="{{ __('Shopname')}}" autocomplete="off">
                    <small class="error-message" style="display: none;" id="shopname-error"></small>
                </div>
                <div class="form-group">
                    <input id="resgiter-password" class="form-control" type="password" name="your-pass" placeholder="{{ __('Password')}}">
                    <small class="error-message" style="display: none;" id="password-error"></small>
                </div>
                <div class="form-group">
                    <input id="resgiter-repassword" class="form-control" type="password" name="your-repass" placeholder="{{ __('Repeat Password')}}">
                    <small class="error-message" style="display: none;" id="repeat-password-error"></small>
                </div>
                <div class="form-group" id="register-error" style="display: none;">
                    <small class="error-message"></small>
                </div>
                <div class="account-action">
                    <div class="account-action-confirm">
                        <button id="resgiter-account" type="button" class="button btn-primary" name="button">
                            {{ __('Register')}}
                        </button>
                    </div>
                    <div class="account-action-cancel">
                        <a href="{{$loginUrl}}" target="_blank" class="button btn-secondary back-login">
                            {{ __('Login')}}
                        </a>
                    </div>
                </div>
                <!-- <label for="special-offers" class="checkbox-label">
                    <input id="special-offers" type="checkbox" class="checkbox-input" name="special-offers">
                    <span class="input-type-checkbox"></span>
                    <small>{{ __('Email me special offers and artist news.')}}</small>
                </label> -->
            </form>
        </fieldset>
    </div>
</main>

@endsection
@section('js')
@parent
<script>
    var messages = {
        required: {
            email: "{{ __('Please enter your email!') }}",
            shop_name: "{{ __('Please enter shop name!') }}",
            password: "{{ __('Please enter your password!') }}",
            repeat_password: "{{ __('Please enter repeat password!') }}",
        },
        email: "{{ __('Your email address is not valid!') }}",
        match_password: "{{ __('Repeat password is not match with your password!') }}",
        error: "{{ __('There was an error. Please try again later.') }}",
    }
    var locale = "<?= $locale ?>";
    var sellerUrl = "<?= $sellerUrl ?>";
</script>
<script src="{{ Module::asset('seller/js/seller.js?v=' . config('sa.version')) }}" charset=" utf-8"></script>
@endsection
