@extends('system.layout.main', [
    'ngController' => 'SellerProductCommissionController'
])

@section('title')
    <title>Seller Product Commission</title>
@endsection

@section('css')
    <style>
        .btn-link {
            cursor: pointer;
        }

        .chosen-container-multi {
            width: 100% !important;
            min-width: 150px;
        }

        .chosen-container-multi .chosen-choices li.search-field input[type=text] {
            color: #999;
            height: 30px;
            min-width: 150px;
            padding: 2px 8px;
        }

        .chosen-container-single .chosen-single, .chosen-container-multi .chosen-choices {
            background: #fff;
            box-shadow: none;
            border: 1px solid #ced4da;
            border-radius: 3px;
        }

        .chosen-container-multi .chosen-choices li.search-choice {
            border: none;
            margin-top: 6px;
        }
    </style>
@endsection

@section('content')
    
    <!-- Modal -->
    <div class="modal fade" id="configCommissionModal" tabindex="-1" role="dialog" aria-labelledby="configCommissionModalLabel">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="configCommissionModalLabel">Commission config</h4>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label for="selectCategories">Select categories</label>
                    <select class="form-control chosen-select" id="selectCategories"
                        multiple
                        chosen
                        persistent-create-option="true"
                        skip-no-results="true"
                        ng-model="selectedCategoryIds"
                        ng-options="category.id as category.name for category in categories">
                    </select>
                </div>

                <div class="form-group">
                    <label for="inputCommission">Commission (%)</label>
                    <input style="max-width: 100px" ng-model="commissionValue" class="form-control" id="inputCommission" type="number">
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" ng-click="saveCommission()" class="btn btn-primary">Save changes</button>
            </div>
        </div>
        </div>
    </div>
    
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Seller Product Commission <img ng-if="states.isLoading" width="30" height="30" src="/images/loading.gif">
                    </h3>
                </div>
                <div class="pull-right">
                    <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#configCommissionModal">
                        Change commission
                    </button>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">

                <div class="box no-border">

                    <div class="box-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 10px">
                                        #
                                    </th>
                                    <th>Name</th>
                                    <th class="text-center">Commission</th>
                                    <th class="text-center">Last updated</th>
                                </tr>
                            </thead>
                            <tbody class="striped-row">
                                <tr ng-repeat="config in configs">
                                    <td style="vertical-align: middle;" class="text-center">
                                        @{{ $index + 1 }}
                                    </td>
                                    <td style="vertical-align: middle;" ng-bind-html="config.name"></td>
                                    <td class="text-center" style="vertical-align: middle;">@{{ config.commission }}%</td>
                                    <td class="text-center">
                                        @{{ config.updated_at }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        
                        
                    </div>

                    <div class="box-footer">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        var baseApiUrl = '{{ config("sa.api_url") }}';
    </script>
    <script src="{{ Module::asset('seller/js/sellers-product-commission-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
@endsection