@extends('system.layout.main', [
    'ngController' => 'SellerAdvertisedProductController'
])

@section('title')
    <title>Seller Advertised Products</title>
@endsection

@section('css')
    <style>
        .btn-link {
            cursor: pointer;
        }
        .chosen-container-single,
        .chosen-container-multi {
            width: auto !important;
            min-width: 180px!important;
        }

        .chosen-single {
            height: 100%;
            line-height: 25px;
            background-color: transparent !important;
            box-shadow: none !important;
            background-image: none !important;
            height: 33px!important;
        }
        
        .label-check-product {
            margin: 0;
            cursor: pointer;
        }

        .chosen-container-single .chosen-single span {
            height: 33px;
            line-height: 33px;
        }

    </style>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Sellers Advertised Products <img ng-if="states.isLoading" width="30" height="30" src="/images/loading.gif">
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">

                <div class="box no-border">

                    <div style="padding: 8px 10px">
                        <label for="filterSeller">
                            Trạng thái:
                        </label>

                        <select ng-model="filters.status" ng-change="changeSellerFilter()"
                            id="filterSellerStatus" class="form-control" style="width: auto; display: inline-block">
                            <option value="">-- Tất cả --</option>
                            <option value="1"> Đã duyệt </option>
                            <option value="0"> Chờ duyệt </option>
                        </select>

                        <label for="filterSeller">
                            Seller:
                        </label>
                        <select chosen ng-model="filters.sellerId" ng-change="changeSellerFilter()"
                            id="filterSeller" class="form-control" style="width: auto; display: inline-block">
                            <option value="">-- All --</option>
                            <option ng-repeat="seller in sellers" value="@{{ seller.id }}">@{{ seller.name }}</option>
                            {{-- @foreach ($sellers as $seller)
                            <option value="{{ $seller->id }}">{{ $seller->name }}</option>
                            @endforeach --}}
                        </select>

                        <div ng-show="sellerProductCount" style="display: inline-block">
                            (Approved: <strong>@{{ sellerProductCount.approved }}</strong> - 
                            Waiting: <strong>@{{ sellerProductCount.waiting }}</strong> )
                        </div>

                    </div>

                    <div ng-show="showBulkAction" style="padding: 8px 10px">
                        <button ng-click="bulkApprovedProduct()" class="btn btn-success">Approved</button>
                        <button ng-click="bulkRejectProduct()" class="btn btn-danger">Reject</button>
                    </div>

                    <div class="box-body">

                        <table class="table">
                            <tr>
                                <th>
                                    <input type="checkbox"
                                        ng-change="changeCheckAll()" 
                                        ng-model="selectAllProduct"/>
                                </th>
                                <th>Product</th>
                                <th>Seller</th>
                                <th>Action</th>
                            </tr>
                            <tr ng-repeat="product in products" ng-class="{'success': product.approve_advertising}">
                                <td style="vertical-align: middle;">
                                    <label class="label-check-product">
                                        <input type="checkbox"
                                            ng-change="changeProductSelection()" 
                                            ng-model="selectedProductIds[product.id]"/>
                                        @{{ product.id }}
                                    </label>
                                </td>
                                <td style="max-width: 400px">
                                    <img width="65" ng-src="@{{ product.image_url }}"/>
                                    <a target="_blank" href="/@{{ product.slug }}-p@{{ product.id }}">@{{ product.name }}</a>
                                </td>
                                <td style="max-width: 200px">
                                    <a target="_blank" href="/@{{ product.seller_slug }}">@{{ product.seller_name }}</a>
                                </td>
                                <td>
                                    <button ng-show="!product.approve_advertising" ng-click="approvedProduct(product)" class="btn btn-success">Duyệt</button>
                                    <button ng-show="product.approve_advertising" ng-click="rejectProduct(product)" class="btn btn-danger">Từ chối</button>
                                </td>
                            </tr>
                        </table>
                        
                    </div>
                    <div class="box-footer">
                        <nav ng-if="productPagination.number_page > 1">
                            <ul class="pagination" style="margin:0">
                
                                <li ng-repeat="n in range(productPagination.current_page - 4, productPagination.current_page - 1)" 
                                    ng-if="n > 0"
                                    class="page-item">
                                    <a ng-click="productPagination.current_page = n; getProducts();" class="page-link" href="#">@{{ n }}</a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="#">@{{ productPagination.current_page }}</a></li>
                                <li ng-repeat="n in range(productPagination.current_page + 1, productPagination.current_page + 4)" 
                                    ng-if="n <= productPagination.number_page"
                                    class="page-item">
                                    <a ng-click="productPagination.current_page = n; getProducts();" class="page-link" href="#">@{{ n }}</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        var baseApiUrl = '{{ config("sa.api_url") }}';
    </script>
    <script src="{{ Module::asset('seller/js/sellers-avertised-product-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
@endsection