@extends('system.layout.main', [
    'ngController' => 'SellerDashboardController'
])

@section('title')
    <title>Seller Dashboard</title>
@endsection

@section('css')
    <link rel="stylesheet" href="{{ Module::asset('seller/css/pages/dashboard/index.css') . '?v=' . time() }}">
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });
        const sellerUrl = '<?=  config("seller::sa.seller_url"); ?>' ;

    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/highcharts/10.3.3/highcharts.js"></script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/seller-dashboard-controller.js') . '?v=' . Config::get("sa.version") }}" charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div class="seller-dashboard-page content">
        <div class="row">
            <div class="col-md-12 text-left" style="margin-bottom: 20px">
                <form class="form-inline">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">Từ <span class="hidden-xs">ngày</span></span>
                            <input type="text" class="form-control" id="date-from" placeholder="yyyy-mm-dd"
                                autocomplete="off" />
                            <span class="input-group-addon">đến <span class="hidden-xs">ngày</span></span>
                            <input type="text" class="form-control" id="date-to" placeholder="yyyy-mm-dd"
                                autocomplete="off" />
                        </div>
                    </div>

                    <div class="form-group text-center">
                        <button type="button" class="btn btn-primary" ng-click="getReportByTine()">Xem thống kê</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="row mb-4 g-3">
            <div class="col-sm-3 col-xl-3">
                <div class="statistic-item">
                    <div class="item-content">
                        <h3 class="mb-0">@{{ statisticSeller.total_seller ? statisticSeller.total_seller : 0 }}</h3>
                        <p>Tổng seller</p>
                    </div>
                    <div class="item-icon">
                        <span class="circel-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-shop" viewBox="0 0 16 16">
                                <path
                                    d="M2.97 1.35A1 1 0 0 1 3.73 1h8.54a1 1 0 0 1 .76.35l2.609 3.044A1.5 1.5 0 0 1 16 5.37v.255a2.375 2.375 0 0 1-4.25 1.458A2.371 2.371 0 0 1 9.875 8 2.37 2.37 0 0 1 8 7.083 2.37 2.37 0 0 1 6.125 8a2.37 2.37 0 0 1-1.875-.917A2.375 2.375 0 0 1 0 5.625V5.37a1.5 1.5 0 0 1 .361-.976l2.61-3.045zm1.78 4.275a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 1 0 2.75 0V5.37a.5.5 0 0 0-.12-.325L12.27 2H3.73L1.12 5.045A.5.5 0 0 0 1 5.37v.255a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0M1.5 8.5A.5.5 0 0 1 2 9v6h1v-5a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v5h6V9a.5.5 0 0 1 1 0v6h.5a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1H1V9a.5.5 0 0 1 .5-.5M4 15h3v-5H4zm5-5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1zm3 0h-2v3h2z" />
                            </svg>
                        </span>

                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xl-3">
                <div class="statistic-item">
                    <div class="item-content">
                        <h3 class="mb-0">@{{ statisticSeller.total_new_seller ? statisticSeller.total_new_seller : 0 }}</h3>
                        <p>Seller đăng ký mới</p>
                    </div>
                    <div class="item-icon">
                        <span class="circel-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-person-add" viewBox="0 0 16 16">
                                <path
                                    d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m.5-5v1h1a.5.5 0 0 1 0 1h-1v1a.5.5 0 0 1-1 0v-1h-1a.5.5 0 0 1 0-1h1v-1a.5.5 0 0 1 1 0m-2-6a3 3 0 1 1-6 0 3 3 0 0 1 6 0M8 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4" />
                                <path
                                    d="M8.256 14a4.474 4.474 0 0 1-.229-1.004H3c.001-.246.154-.986.832-1.664C4.484 10.68 5.711 10 8 10c.26 0 .507.009.74.025.226-.341.496-.65.804-.918C9.077 9.038 8.564 9 8 9c-5 0-6 3-6 4s1 1 1 1z" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xl-3">
                <div class="statistic-item">
                    <div class="item-content">
                        <h3 class="mb-0">@{{ statisticSeller.total_order ? statisticSeller.total_order : 0 }}</h3>
                        <p>Số đơn hàng</p>
                    </div>
                    <div class="item-icon">
                        <span class="circel-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-cart" viewBox="0 0 16 16">
                                <path
                                    d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5M3.102 4l1.313 7h8.17l1.313-7H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4m7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4m-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2m7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-sm-3 col-xl-3">
                <div class="statistic-item">
                    <div class="item-content">
                        <h3 class="mb-0">$@{{ statisticSeller.total_revenue ? statisticSeller.total_revenue : 0 }}</h3>
                        <p>Doanh thu</p>
                    </div>
                    <div class="item-icon">
                        <span class="circel-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-currency-dollar" viewBox="0 0 16 16">
                                <path
                                    d="M4 10.781c.148 1.667 1.513 2.85 3.591 3.003V15h1.043v-1.216c2.27-.179 3.678-1.438 3.678-3.3 0-1.59-.947-2.51-2.956-3.028l-.722-.187V3.467c1.122.11 1.879.714 2.07 1.616h1.47c-.166-1.6-1.54-2.748-3.54-2.875V1H7.591v1.233c-1.939.23-3.27 1.472-3.27 3.156 0 1.454.966 2.483 2.661 2.917l.61.162v4.031c-1.149-.17-1.94-.8-2.131-1.718H4zm3.391-3.836c-1.043-.263-1.6-.825-1.6-1.616 0-.944.704-1.641 1.8-1.828v3.495l-.2-.05zm1.591 1.872c1.287.323 1.852.859 1.852 1.769 0 1.097-.826 1.828-2.2 1.939V8.73l.348.086z" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Độ phát triển của Seller</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                    class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="seller-growth-rate"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Sản phẩm seller submit</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                    class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 400px">
                        <div id="product-submitted-by-the-seller"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Đơn hàng của Seller</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                    class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="orders-seller"></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h4 class="box-title">Doanh thu theo loại</h4>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i
                                    class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body" style="min-height: 500px">
                        <div id="revenue-seller"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
