<div class="table-filter col-md-12">
    <table class="table table-bordered">
        <thead>
            <tr id="js-table-head">
                <th style="width: 5px">
                    #
                </th>
                <th>Code</th>
                <th style="width: 20%">Shop Name</th>
                <th style="width: 25%;">Period</th>
                <th style="width: 15%">Amount</th>
                <th style="width: 15%">Payment Date</th>
                <th style="width: 15%">Payment Status</th>
                <!-- <th></th> -->
            </tr>
        </thead>

        <tbody class="list-order-contain">
            <tr ng-show="invoices.length > 0 && !isLoadingDesign" ng-repeat="invoice in invoices" class="list-order-body">
                <td>
                    <span ng-bind="$index + 1"></span>
                </td>
                <td>
                    @{{invoice.code}}
                </td>
                <td>
                    @{{invoice.name}}
                </td>
                <td>
                    @{{invoice.period_from}} to @{{invoice.period_to}}
                </td>
                <td>
                    @{{invoice.amount}}
                </td>
                <td>
                    @{{invoice.payment_date ? invoice.payment_date : N/A}}
                </td>
                <td>
                    <select 
                        ng-change="updatedInvoice(invoice, 'payment_status', invoice.payment_status)" 
                        ng-options="status for status in statuses"
                        ng-model="invoice.payment_status"
                        class="form-control ng-pristine ng-valid ng-not-empty btn-default ng-touched"
                    >
                    </select>
                </td>
                
            </tr>
            <tr ng-show="invoices.length === 0 && !isLoadingDesign">
                <td colspan="9" class="text-center">
                    <div class="empty-contain flex-box align-c flex-c">
                        <img src="/system/images/empty.png" alt="">
                        <span>Empty</span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>