@extends('system.layout.main', [
    'ngController' => 'FakeSellersController'
])

@section('title')
    <title>Fake Sellers Management</title>
@endsection

@section('css')

    <style>
        .bulk-actions {
            padding: 10px 0px;
            width: 100%;
        }
    </style>
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();
        
        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/fake-sellers-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Fake Sellers 
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                            <li class="all-item">
                                <a href="javascript:void(0)" style="cursor: pointer">
                                    Sellers
                                </a>
                            </li>
                        </ul>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        @include('seller::system.fake-sellers.filter')
                        @include('seller::system.fake-sellers.list')

                        <div class="pull-right" ng-if="fakeSellers.length > 0 && !isLoadingDesign">
                            @include('system.pagination')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection