@extends('system.layout.main', [
    'ngController' => 'SellerInvoiceController'
])

@section('title')
    <title>Invoice</title>
@endsection

@section('css')
    <style>
        .bulk-actions {
            padding: 10px 0px;
            width: 100%;
        }
    </style>
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });
        const sellerUrl = '<?=  config("seller::sa.seller_url"); ?>' ;

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/seller-invoice-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
    <script src="{{ Module::asset('seller/js/invoice.js') . '?v=' . config('sa.version') }}"></script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Invoice
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <ul id="tab-nav-bar" class="nav nav-tabs">
                    <li class="active tab-nav-bar__item" ng-click="changeTab('monthly')" target-table="content-monthly"><a href="#">{{ __('Monthly') }}</a></li>
                    <li class="tab-nav-bar__item" ng-click="changeTab('weekly')" target-table="content-weekly"><a href="#">{{ __('Weekly') }}</a></li>
                </ul>
                <div id="content-monthly" class="box no-border table-content">
                    <div class="nav-tabs-custom" style="margin-bottom:0">
                    </div>
                    <div class="box-body">
                        @include('seller::system.invoice.filter')
                        @include('seller::system.invoice.list')
                        @include('system.pagination')
                    </div>
                </div>
                
                <div id="content-weekly" class="box no-border table-content d-none">
                    <div class="nav-tabs-custom" style="margin-bottom:0">
                    </div>
                    <div class="box-body">
                        @include('seller::system.invoice.filter-weekly')
                        @include('seller::system.invoice.list-weekly')
                        @include('system.pagination')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection