<div class="table-filter col-md-12">
    <div style="position: relative">
        <div class="bulk-actions pt-2" ng-show="totalInvoiceSelected > 0" aria-hidden="false" style="">
            <div class="bulk-actions-inner">
                <ul class="bulk-actions-inner-bar">
                    <li class="segments" style="background: #dfe3e8; font-weight: bold;">
                        <input id="js-reset-check-all" type="checkbox" ng-model="checkAll" ng-change="checkAllInvoice()">
                        <span class="ng-binding ml-2"> @{{ totalInvoiceSelected }} invoices selected</span>
                    </li>
                    <li class="segments dropdown open" style="cursor: pointer; display: inline-block; width: auto">
                        <span class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                            Change payment status <span class="caret"></span>
                        </span>
                        <ul class="dropdown-menu" style="left: -4px;clear: both;padding: 0;margin-top: 6px;">

                            <li class="actions p-3" ng-click="bulkChangePaymentStatus(status)" role="button" tabindex="0" ng-repeat="status in statuses">
                                @{{status}}
                            </li>
                            
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr id="js-table-head">
                <th style="width: 45px">
                    <div style="width: 45px">
                        <input class="form-check-input mr-2" type="checkbox" ng-model="checkAll" ng-change="checkAllInvoice()">
                        #
                    </div>
                </th>
                <th>Code</th>
                <th style="width: 10%">Shop Name</th>
                <th style="width: 10%">Email</th>
                <th style="width: 10%">Payment Email</th>
                <th style="width: 25%;">Period</th>
                <th style="width: 15%">Amount</th>
                <th style="width: 15%">Payment Date</th>
                <th style="width: 15%">Payment Status</th>
                <!-- <th></th> -->
            </tr>
        </thead>

        <tbody class="list-order-contain">
            <tr ng-show="invoices.length > 0 && !isLoadingDesign" ng-repeat="invoice in invoices"
                class="list-order-body">
                <td>
                    <div>
                        <input class="form-check-input mr-2" type="checkbox" ng-model="invoice.is_checked" ng-change="checkOneInvoice()">
                        <span ng-bind="$index + 1"></span>
                    </div>
                </td>
                <td>
                    @{{ invoice.code }}
                </td>
                <td>
                    @{{ invoice.shop_name }}
                </td>
                <td>
                    @{{ invoice.email }}
                </td>
                <td>
                    @{{ invoice.payment_email }}
                </td>
                <td>
                    @{{ invoice.period_from }} to @{{ invoice.period_to }}
                </td>
                <td>
                    @{{ invoice.amount }}
                </td>
                <td>
                    @{{ invoice.payment_date ? invoice.payment_date : N / A }}
                </td>
                <td>
                    <select ng-change="updatedInvoice(invoice, 'payment_status', invoice.payment_status)"
                        ng-options="status for status in statuses" ng-model="invoice.payment_status"
                        class="form-control ng-pristine ng-valid ng-not-empty btn-default ng-touched"
                        ng-disabled="invoice.payment_status === 'PAID'">
                    </select>
                </td>

            </tr>
            <tr ng-show="invoices.length === 0 && !isLoadingDesign">
                <td colspan="9" class="text-center">
                    <div class="empty-contain flex-box align-c flex-c">
                        <img src="/system/images/empty.png" alt="">
                        <span>Empty</span>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>
