@extends('system.layout.main', [
    'ngController' => 'SellerReportCreatedProduct'
])

@section('title')
    <title>Seller Product Created</title>
@endsection

@section('css')
    <style>
        .btn-link {
            cursor: pointer;
        }

        .chosen-container-multi {
            width: 100% !important;
            min-width: 150px;
        }

        .chosen-container-multi .chosen-choices li.search-field input[type=text] {
            color: #999;
            height: 30px;
            min-width: 150px;
            padding: 2px 8px;
        }

        .chosen-container-single .chosen-single, .chosen-container-multi .chosen-choices {
            background: #fff;
            box-shadow: none;
            border: 1px solid #ced4da;
            border-radius: 3px;
        }

        .chosen-container-multi .chosen-choices li.search-choice {
            border: none;
            margin-top: 6px;
        }
    </style>
@endsection

@section('content')
    
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Seller Product Created <img ng-if="states.isLoading" width="30" height="30" src="/images/loading.gif">
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">

                <div class="row" style="margin-bottom: 8px;">
                    <div class="col-md-2">
                        <input
                            type="text"
                            class="form-control"
                            ng-model="filter.dateFrom"
                            my-date-picker
                            placeholder="<?= __s("Date from")?>"
                        >
                    </div>
                    <div class="col-md-2">
                        <input
                            type="text"
                            class="form-control"
                            ng-model="filter.dateTo"
                            my-date-picker
                            placeholder="<?= __s("Date to")?>"
                        >
                    </div>
                    <div class="col-md-4">
                        <button type="button" class="btn btn-primary " ng-click="find()">
                            <i class="fa fa-search"></i>
                            Search
                        </button>
                    </div>
                </div>

                <div class="box no-border">

                    <div class="box-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 10px">
                                        #
                                    </th>
                                    <th>Name</th>
                                    <th>Product count</th>
                                </tr>
                            </thead>
                            <tbody class="striped-row">
                                <tr ng-repeat="value in sellerProductCount track by $index">
                                    <td></td>
                                    <td>@{{ value.name }}</td>
                                    <td>@{{ value.total }}</td>
                                </tr>
                            </tbody>
                        </table>
                        
                        
                    </div>

                    <div class="box-footer">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        var baseApiUrl = '{{ config("sa.api_url") }}';
    </script>
    <script src="{{ Module::asset('seller/js/sellers-product-created-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
@endsection