<div class="modal fade" id="revenue-detail" style="height: 95%; margin-top: 20px;">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    Revenue detail of @{{ currentItem.email }}
                </h4>
            </div>
            
            <div class="modal-body">
                <div class="row p-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <select ng-model="detailFilter.status" class="form-control" ng-options="status.code as status.name for status in statuses" ng-change="getRevenueBySeller()">
                                <option value="all">All Status</option>
                            </select>
                        </div>
                    </div>
                </div>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>STT</th>
                            <th>Product</th>
                            <th>Order</th>
                            <th>Revenue</th>
                            <th>Payment</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Available date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="item in currentItem.revenues track by $index">
                            <td>@{{ $index + 1 }}</td>
                            <td>@{{ item.product_name }}</td>
                            <td>@{{ item.order_code }}</td>
                            <td>@{{ formatPrice(item.revenue) }}</td>
                            <td>@{{ formatPrice(item.payment) }}</td>
                            <td>@{{ item.status }}</td>
                            <td>@{{ item.date }}</td>
                            <td>@{{ item.available_date }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-right" data-dismiss="modal" ng-click="closeModalCreate()" style="margin-left: 10px">Close</button>
                <button id="btnSave" ng-click="saveNewJob()" type="button" class="btn btn-success" ng-disabled="isLoading">Create</button>
            </div>
        </div>
    </div>
</div>