@extends('system.layout.main')

@section('title')
    <title>Seller Revenues</title>
@endsection

@section('css')
    <link rel="stylesheet" href="{{ Module::asset('seller/css/system/sellers/statistic.css') . '?v=' . time() }}">
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?= config('sa.file_manager_url') ?>';
        var baseApiUrl = '{{ config('sa.api_url') }}';
        const userLogin = <?= json_encode(\Illuminate\Support\Facades\Auth::user()) ?>;
        let locals = <?= json_encode(getModuleLocale()) ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });
        const sellerUrl = '<?= config('seller::sa.seller_url') ?>';
        const sellerAuthKey = '<?= config('sa.seller_auth_key', '') ?>';
    </script>

    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get('sa.version') ?>"
        charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/seller-revenue-controller.js') . '?v=' . Config::get('sa.version') }}"
        charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div class="seller-dashboard-page content" ng-controller="SellerRevenueController">
        <div class="card" style="background-color:white">
            <div class="card-header">
                <h4 class="card-title">Seller Revenues</h4>
            </div>
            <div class="col-md-12 row">
                <div class="col-md-6">
                    <div class="form-group">
                        <input ng-keyPress="$event.keyCode === 13 && find()" ng-model="filter.email" type="text"
                            class="form-control" placeholder="Search seller by email..." />
                    </div>
                </div>
                <div class="col-md-3">
                    <input type="text" class="form-control" ng-model="filter.dateFrom" my-date-picker
                        placeholder="<?= __s('Date from') ?>">
                </div>
                <div class="col-md-3">
                    <input type="text" class="form-control" ng-model="filter.dateTo" my-date-picker
                        placeholder="<?= __s('Date to') ?>">
                </div>
            </div>
            <div class="col-md-12 mb-3 row">
                <button type="button" class="btn btn-primary ml-4" ng-click="find()">
                    <i class="fa fa-search"></i>
                    Search
                </button>
                <button type="button" class="btn btn-default " ng-click="clear()">
                    <i class="fa fa-refresh"></i>
                    Clear form
                </button>
            </div>
            <div class="card-body">
                <table class="table table-bordered text-center">
                    <thead>
                        <tr>
                            <th rowspan="2" scope="col">#</th>
                            <th rowspan="2" scope="col" style="text-align: left">Seller</th>
                            <th colspan="2">PENDING</th>
                            <th colspan="2">AVAILABLE</th>
                            <th colspan="2">PAID</th>
                            <th colspan="2">CANCEL</th>
                        </tr>
                        <tr>
                            <th>Revenue</th>
                            <th>Payment</th>
                            <th>Revenue</th>
                            <th>Payment</th>
                            <th>Revenue</th>
                            <th>Payment</th>
                            <th>Revenue</th>
                            <th>Payment</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="item in items track by $index">
                            <td>@{{ getIndexNo($index) }}</td>
                            <td> <b style="cursor: pointer" ng-click="showRevenueDetail(item)">@{{ item.email }}</b></td>
                            <td>@{{ item.PENDING ? formatPrice(item.PENDING.total_revenue) : ''}}</td>
                            <td>@{{ item.PENDING ? formatPrice(item.PENDING.total_payment) : ''}}</td>
                            <td>@{{ item.AVAILABLE ? formatPrice(item.AVAILABLE.total_revenue) : ''}}</td>
                            <td>@{{ item.AVAILABLE ? formatPrice(item.AVAILABLE.total_revenue) : ''}}</td>
                            <td>@{{ item.CANCELED ? formatPrice(item.CANCELED.total_revenue) : ''}}</td>
                            <td>@{{ item.CANCELED ? formatPrice(item.CANCELED.total_revenue) : ''}}</td>
                            <td>@{{ item.PAID ? formatPrice(item.PAID.total_revenue) : ''}}</td>
                            <td>@{{ item.PAID ? formatPrice(item.PAID.total_revenue) : ''}}</td>
                        </tr>
                    </tbody>
                </table>
                @include('system.pagination')
                <br>
            </div>
        </div>
        @include('seller::system.revenue.detail')
    </div>
@endsection
