<div ng-controller="NewProductEveryDayController">
    <div class="card" style="background-color:white">
        <div class="card-header">
            <h4 class="card-title">New products every day</h4>    
        </div>
        <div class="card-body">
            @include('seller::system.seller-statistic.inc.new-product-filter')
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Seller</th>
                        <th scope="col" ng-repeat='date in dates'>@{{date}}</th>
                        <th scope="col">Total Product</th>
                    </tr>
                </thead>
                <tbody>
                    <tr ng-repeat="item in items">
                        <th scope="row">@{{$index + 1}}</th>
                        <td>@{{item.email}}</td>
                        <td ng-repeat="date in dates">
                            @{{ item.dates && item.dates[date] ? item.dates[date] : '-' }}
                        </td>
                        <td>@{{item.total}}</td>
                    </tr>
                </tbody>
            </table>
            @include('system.pagination')
            <br>
        </div>
    </div>

</div>