@extends('system.layout.main')

@section('title')
    <title>Seller Statistics</title>
@endsection

@section('css')
    <link rel="stylesheet" href="{{ Module::asset('seller/css/system/sellers/statistic.css') . '?v=' . time() }}">
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?= config('sa.file_manager_url') ?>';
        var baseApiUrl = '{{ config('sa.api_url') }}';
        const userLogin = <?= json_encode(\Illuminate\Support\Facades\Auth::user()) ?>;
        let locals = <?= json_encode(getModuleLocale()) ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });
        const sellerUrl = '<?= config('seller::sa.seller_url') ?>';
    </script>

    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get('sa.version') ?>"
        charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/seller-statistic/new-product-every-day.js') . '?v=' . Config::get('sa.version') }}"
        charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div class="seller-dashboard-page content">
        @include('seller::system.seller-statistic.inc.new-product')
    </div>
@endsection
