<style media="screen">
    .seller-popup-wrapper {
        display: none;
    }
    .seller-popup-wrapper.active {
        display: block !important;
    }
    .seller-popup-wrapper,
    .seller-popup-background {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 5000;
        width: 100%;
        height: 100%;
        display: none;
        font-family: Arial;
    }

    .seller-popup-background {
        display: block;
        background-color: rgba(11 11 11 / 44%);
        z-index: 1;
    }

    .seller-popup-content {
        width: 100%;
        max-width: 1200px;
        background-color: #fff;
        border-radius: 5px;
        box-shadow: 0 8px 10px -5px rgb(0 0 0 / 20%), 0 16px 24px 2px rgb(0 0 0 / 14%), 0 6px 30px 5px rgb(0 0 0 / 10%);
        position: fixed;
        top: 50px;
        left: 50%;
        transform: translateX(-50%);
        min-height: 100px;
        z-index: 3;
    }
    @media (max-height: 650px) {
        .seller-popup-content {
            max-height: calc(100vh - 100px);
            overflow-y: auto;
        }
    }

    .seller-gr {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .seller-popup-row {
        display: flex;
        align-items: center;
        justify-content: flex-start;
        padding: 5px 10px;
        user-select: none;
    }

    .seller-gr .seller-popup-row:last-child > *:last-child {
        min-width: 200px;
    }

    .seller-gr:hover,
    .seller-popup-row:hover,
    .filter-head,
    .order-head {
        background-color: #f8f8f8;
        color: #0069d9;
    }

    .seller-popup-row .fr {
        min-width: 100px;
        margin-right: 10px;
        font-weight: 500;
    }

    .seller-popup-header {
        padding: 12px;
        position: relative;
        font-weight: 500;
        user-select: none;
    }

    .close-seller-popup {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        right: 14px;
        cursor: pointer;
        color: #666;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .seller-popup-detail {
        border-top: 1px solid #e1e1e1;
        border-bottom: 1px solid #e1e1e1;
        padding: 12px 16px;
    }

    .seller-popup-footer {
        padding: 12px;
        display: flex;
        justify-content: flex-end;
        align-items: center;
    }

    .button-seller {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-left: 10px;
        font-weight: 500;
        outline: none;
        border: none;
        border-radius: 5px;
        padding: 10px 16px;
        cursor: pointer;
        user-select: none;
    }

    .button-seller svg {
        margin-right: 4px;
        font-size: 14px;
    }

    .button-seller-popup-order {
        color: #fff;
        background-color: #007bff;
        border-color: #007bff;
    }
    .button-seller-popup-export {
        color: #fff;
        background-color: #218838;
        border-color: #1e7e34;
    }

    .seller-popup-filter {
        margin: 12px 0;
        background-color: #f8f8f8;
        padding: 10px 0;
    }

    .filter-list {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0 5px;
    }

    .filter-head {
        font-weight: 600;
        padding: 5px  10px;
        display: none;
    }

    .seller-popup-filter span {
        user-select: none;
        width: 24px;
        min-width: 24px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .ip-filter {
        outline: none;
        border: 1px solid #e1e1e1;
        padding: 10px 16px;
        color: #333;
        border-radius: 5px;
        width: 100%;
        margin: 0 5px;
    }
    select.ip-filter {
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: linear-gradient(45deg, transparent 50%, gray 50%), linear-gradient(135deg, gray 50%, transparent 50%);
        background-position: calc(100% - 10px) 16px, calc(100% - 5px) 16px, calc(100% - 16px);
        background-size: 5px 5px, 5px 5px, 1px calc(100% - 16px);
        background-repeat: no-repeat;
    }

    .tbl-order {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
        text-align: left;
        vertical-align: top
    }

    .tbl-order thead {
        background-color: #f8f8f8;
    }
    .tbl-order thead th {
        white-space: nowrap;
        padding: 5px 10px;
    }

    .tbl-order tbody td {
        padding: 5px 10px;
        vertical-align: top;
        border-top: 1px solid #e1e1e1;
    }


    .tbl-pname {
        width: 360px;
    }

    .div-pname {
        --img: 60px;
        display: flex;
        justify-content: flex-start;
        align-items: flex-start;
    }

    .div-pname + .div-pname {
        margin-top:10px;
        padding-top:10px;
        border-top: 1px solid #e1e1e1;
    }

    .product-name {
        width: calc(100% - var(--img));
        padding-left: 16px;
    }

    .product-img {
        width: var(--img);
        display: block;
        position: relative;
    }

    .product-img::before {
        content: "";
        padding-top: 100%;
        display: block;
    }

    .product-img img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        object-position: center;
        position: absolute;
        top: 0;
        left: 0;
    }
    .open-seller-detail-pop {
        overflow: hidden;
    }
    .tbl-scroll {
        max-height: 300px;
        overflow: hidden auto;
    }
    .special-color {
        color: #007bff;
        font-weight: bold;
    }
    .seller-popup-action {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }
    .seller-popup-action > * {
        margin: 0px;
        margin-right: 5px;
        color: white;
    }
    .seller-popup-action > .button-seller-popup-export {
        margin-left: auto;
    }
    .loading-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 7235;
        width: 100%;
        height: 100%;
        display: none;
        font-family: Arial;
        display: block;
        background-color: rgba(11 11 11 / 55%);
    }

    .loading-wrapper::before {
        content: "";
        width: 64px;
        height: 64px;
        display: block;
        border-radius: 64px;
        border-width: 2px;
        border-style: solid;
        border-color: #fff #fff #fff rgba(255 255 255 / 10%);
        animation: lds-loading 800ms linear infinite;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    @keyframes lds-loading {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }
</style>
<div class="seller-popup-wrapper">
    <div class="seller-popup-content">
        <div class="seller-popup-header">
            <h3 style="margin-top: 5px; margin-bottom: 5px;">@{{ seller.store }} seller's detail</h3>
            
            <span class="close-seller-popup" ng-click="closeFormSeller()">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M13.854 2.146a.5.5 0 0 1 0 .708l-11 11a.5.5 0 0 1-.708-.708l11-11a.5.5 0 0 1 .708 0Z"/>
                    <path fill-rule="evenodd" d="M2.146 2.146a.5.5 0 0 0 0 .708l11 11a.5.5 0 0 0 .708-.708l-11-11a.5.5 0 0 0-.708 0Z"/>
                </svg>
            </span>
        </div>
        <div class="seller-popup-detail">
            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Full name:</span>
                    <span class="ed">@{{ seller.name }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Email:</span>
                    <span class="ed">@{{ seller.email }}</span>
                </div>
            </div>

            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Store:</span>
                    <span class="ed">@{{ seller.store }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Status:</span>
                    <span class="ed">@{{ seller.status }}</span>
                </div>
            </div>

            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Revenue:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_revenue) }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Total commission:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_payment) }}</span>
                </div>
            </div>
            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Available commission:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_payment_available) }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Pending commission:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_payment_pending) }}</span>
                </div>
            </div>
            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Paid commission:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_payment_paid) }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Cancel commission:</span>
                    <span class="ed special-color">@{{ formatPrice(report.total_payment_cancelled) }}</span>
                </div>
            </div>
            <div class="seller-gr">
                <div class="seller-popup-row">
                    <span class="fr">Created at:</span>
                    <span class="ed">@{{ seller.created_at }}</span>
                </div>
                <div class="seller-popup-row">
                    <span class="fr">Recent login:</span>
                    <span class="ed">@{{ seller.updated_at }}</span>
                </div>
            </div>
            <div class="seller-popup-filter">
                <div class="filter-head">Filter:</div>
                <div class="filter-list">
                    <span class="open-filter">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
                            <path d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5v-2zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2h-11z"/>
                        </svg>
                    </span>
                    <input type="text" class="ip-filter" ng-model="filterForm.keyword" placeholder="Search...">
                    <input type="text" class="ip-filter" id="date-from" placeholder="yyyy-mm-dd" />
                    <input type="text" class="ip-filter" id="date-to" placeholder="yyyy-mm-dd" />

                    <select class="ip-filter" ng-model="filterForm.status">
                        <option value="" selected>Select status</option>
                        <option value="PROCESSING">Processing</option>
                        <option value="ISSUED">Issued</option>
                        <option value="FINISHED">Finished</option>
                        <option value="CANCELED">Canceled</option>
                    </select>
                    <!-- <span class="close-filter">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M13.854 2.146a.5.5 0 0 1 0 .708l-11 11a.5.5 0 0 1-.708-.708l11-11a.5.5 0 0 1 .708 0Z"/>
                            <path fill-rule="evenodd" d="M2.146 2.146a.5.5 0 0 0 0 .708l11 11a.5.5 0 0 0 .708-.708l-11-11a.5.5 0 0 0-.708 0Z"/>
                        </svg>
                    </span> -->
                </div>
            </div>
            <div class="seller-popup-action">
                <button type="button" class="button-seller button button-seller-popup-search" ng-click="getSellerInfo(seller)" style="background-color: #007bff;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                    </svg>
                    Search
                </button>
                <button type="button" class="button-seller button button-seller-popup-reset" ng-click="resetFilter(seller)" style="background-color: #007bff;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-repeat" viewBox="0 0 16 16">
                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"/>
                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"/>
                    </svg>
                    Reset
                </button>
                <button type="button" class="button-seller button button-seller-popup-export" ng-click="exportExcel(seller)">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-filetype-csv" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M14 4.5V14a2 2 0 0 1-2 2h-1v-1h1a1 1 0 0 0 1-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5L14 4.5ZM3.517 14.841a1.13 1.13 0 0 0 .401.823c.13.108.289.192.478.252.19.061.411.091.665.091.338 0 .624-.053.859-.158.236-.105.416-.252.539-.44.125-.189.187-.408.187-.656 0-.224-.045-.41-.134-.56a1.001 1.001 0 0 0-.375-.357 2.027 2.027 0 0 0-.566-.21l-.621-.144a.97.97 0 0 1-.404-.176.37.37 0 0 1-.144-.299c0-.156.062-.284.185-.384.125-.101.296-.152.512-.152.143 0 .266.023.37.068a.624.624 0 0 1 .246.181.56.56 0 0 1 .12.258h.75a1.092 1.092 0 0 0-.2-.566 1.21 1.21 0 0 0-.5-.41 1.813 1.813 0 0 0-.78-.152c-.293 0-.551.05-.776.15-.225.099-.4.24-.527.421-.127.182-.19.395-.19.639 0 .201.04.376.122.524.082.149.2.27.352.367.152.095.332.167.539.213l.618.144c.207.049.361.113.463.193a.387.387 0 0 1 .152.326.505.505 0 0 1-.085.29.559.559 0 0 1-.255.193c-.111.047-.249.07-.413.07-.117 0-.223-.013-.32-.04a.838.838 0 0 1-.248-.115.578.578 0 0 1-.255-.384h-.765ZM.806 13.693c0-.248.034-.46.102-.633a.868.868 0 0 1 .302-.399.814.814 0 0 1 .475-.137c.15 0 .283.032.398.097a.7.7 0 0 1 .272.26.85.85 0 0 1 .12.381h.765v-.072a1.33 1.33 0 0 0-.466-.964 1.441 1.441 0 0 0-.489-.272 1.838 1.838 0 0 0-.606-.097c-.356 0-.66.074-.911.223-.25.148-.44.359-.572.632-.13.274-.196.6-.196.979v.498c0 .379.064.704.193.976.131.271.322.48.572.626.25.145.554.217.914.217.293 0 .554-.055.785-.164.23-.11.414-.26.55-.454a1.27 1.27 0 0 0 .226-.674v-.076h-.764a.799.799 0 0 1-.118.363.7.7 0 0 1-.272.25.874.874 0 0 1-.401.087.845.845 0 0 1-.478-.132.833.833 0 0 1-.299-.392 1.699 1.699 0 0 1-.102-.627v-.495Zm8.239 2.238h-.953l-1.338-3.999h.917l.896 3.138h.038l.888-3.138h.879l-1.327 4Z"/>
                    </svg>
                    Export
                </button>
            </div>
            <div class="seller-popup-list-order">
                <div class="tbl-scroll">
                    <table class="tbl-order">
                        <thead>
                            <th class="tbl-code" style="width: 150px;">
                                Order Code
                            </th>
                            <th  class="tbl-cname">
                                Customer
                            </th>
                            <th  class="tbl-pname">
                                Product
                            </th>
                            <th  class="tbl-amount">
                                Amount
                            </th>
                            <th  class="tbl-amount">
                                Commission
                            </th>
                            <th  class="tbl-amount">
                                Payment status
                            </th>
                            <th class="tbl-status">
                                Order status
                            </th>
                        </thead>
                        <tbody>
                            <tr ng-repeat="order in orders">
                                <td class="tbl-code">
                                    <div>
                                        <strong>#@{{ order.code }}</strong>
                                    </div>
                                    <div>
                                        @{{ order.created_at }}
                                    </div>
                                </td>
                                <td class="tbl-cname">
                                    <div>
                                        @{{ order.customer.full_name }}
                                    </div>
                                </td>
                                <td class="tbl-pname">
                                    <div class="div-pname" ng-repeat="product in order.items">
                                        <a href="@{{ product.url }}" class="product-img" target="_blank">
                                            <img ng-src="@{{ product.image_url }}" alt="">
                                        </a>
                                        <div class="product-name">
                                            <a href="@{{ product.url }}" target="_blank">
                                                @{{ product.name }}
                                            </a>
                                        </div>
                                    </div>
                                </td>
                                <td class="tbl-amount">
                                    <span class="ed">@{{ formatPrice(order.amount) }}</span>
                                </td>
                                <td class="tbl-amount">
                                    <span class="ed">@{{ formatPrice(order.payment) }}</span>
                                </td>
                                <td class="tbl-status">
                                    @{{ order.payment_status }}
                                </td>
                                <td class="tbl-status">
                                    @{{ order.status }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="seller-popup-footer">
            
        </div>
    </div>
    <span class="seller-popup-background"></span>
</div>
<div class="loading-wrapper" ng-show="loading"></div>