@extends('system.layout.main', [
    'ngController' => 'SellersController'
])

@section('title')
    <title>Sellers</title>
@endsection

@section('css')
    <style>
        .btn-link {
            cursor: pointer;
        }
    </style>

    <link rel="stylesheet" href="{{ Module::asset('seller/css/system/sellers/index.css') . '?v=' . Config::get("sa.version") }}">
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });
        const sellerUrl = '<?=  config("seller::sa.seller_url"); ?>';

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="{{ Module::asset('seller/js/sellers-controller.js') . '?v=' . Config::get("sa.version") }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Sellers
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="nav-tabs-custom">
                       
                    </div>
                    <div class="box-body">
                        @include('seller::system.sellers.filter')
                        @include('seller::system.sellers.list')
                        @include('seller::system.sellers.form')
                        @include('system.pagination')
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('seller::system.sellers.modal-confirm-suspend')
@endsection