<div class="modal fade" id="design-job-modal" style="height: 95%; margin-top: 20px;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    Create new job
                </h4>
            </div>
            <div class="modal-body">
                    <div class="search-product row">
                        <div class="col-md-12">
                            <div class="col-md-8">
                                <!-- <div class="position-relative">
                                    <label>Product <span class="text-danger">*</span></label>
                                </div> -->
                                <div class="input-group">
                                    <input type="text" ng-model="searchProductText" ng-change="searchProduct()" 
                                        ng-model-options='{ debounce: 500 }' 
                                        type="text" class="form-control" 
                                        placeholder="Search product by SKU">
                                    <span class="input-group-btn">
                                        <button class="btn btn-default" type="submit" ng-click="searchProduct()">
                                            <i class="fa fa-search" aria-hidden="true"></i>Search
                                        </button>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <select
                                        ng-options="local.name for local in locals track by local.code" 
                                        ng-model="newJob.searchLocal"
                                        class="form-control">
                                    </select>
                                </div>

                            </div>

                        </div>
                        <div class="search-product-result mt-2 col-md-12" ng-if="products.length > 0">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th style="width: 100px">SKU</th>
                                    <th style="width: 100px">Image</th>
                                    <th>Name</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="product in products" style="cursor: pointer" ng-click="selectProduct(product)">
                                    <td class="sku" style="width: 100px">@{{ product.sku }}</td>
                                    <td style="width: 100px">
                                        <img class="adminImageSearch" width="100px" ng-src="@{{ getImageCdn(product.image_url, 0, 200) }}" alt="@{{ product.name }}">
                                    </td>
                                    <td>@{{ product.name }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div>
                        <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th style="width: 100px">SKU</th>
                                    <th style="width: 100px">Image</th>
                                    <th>Name</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="product in newJob.products" style="cursor: pointer">
                                    <td class="sku" style="width: 100px">@{{ product.sku }}</td>
                                    <td style="width: 100px">
                                        <img class="adminImageSearch" width="100px" ng-src="@{{ getImageCdn(product.image_url, 200, 0) }}" alt="@{{ product.name }}">
                                    </td>
                                    <td>@{{ product.name }}</td>
                                    <td>
                                        <button class="btn btn-danger" ng-click="removeProductNewJob(product)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                    </div>
                    <div>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="exampleCheck1" 
                                ng-click="newJob.isCustom = !newJob.isCustom"
                            >
                            <label class="form-check-label" for="exampleCheck1" 
                                >
                                Custom product
                            </label>
                        </div>
                        <div ng-if="newJob.isCustom" class="thumbnail-design-container" style="max-width: 100%">
                            <button class="add-image-button" 
                                ngf-select="uploadImageCustom($files)" 
                                ngf-multiple="true"
                            >
                                <i class="fa fa-plus" aria-hidden="true"></i>
                            </button>
                            <div ng-repeat="customImage in newJob.customImages track by $index"
                                style="position: relative;"
                                >
                                <div class="thumbnail">
                                    <a data-magnify="gallery"
                                        data-caption="@{{ customImage.name }}"
                                        data-group=""
                                        data-src="@{{ customImage.image_url }}"
                                        href="@{{ customImage.image_url }}"
                                    >
                                        <img src="@{{  getImageCdn(customImage.image_url, 0, 150) }}" alt="@{{ customImage.name }}">
                                    </a>
                                </div>
                                <a class="delete-icon" 
                                    ng-click="removeCustomImage($index)">
                                    <i class="fa fa-times-circle"></i>
                                </a>
                                
                            </div>  
                        </div>
                
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-right" data-dismiss="modal" ng-click="closeModalCreate()" style="margin-left: 10px">Close</button>
                <button id="btnSave" ng-click="saveNewJob()" type="button" class="btn btn-success" ng-disabled="isLoading">Create</button>
            </div>
        </div>
    </div>
</div>