<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'module/seller', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', [
        'as' => 'seller::index',
        'uses' => 'HomeController@indexSeller',
    ]);
    Route::get('/invoice', [
        'as' => 'seller::invoice',
        'uses' => 'HomeController@indexSellerInvoice',
    ]);
});

Route::group(['prefix' => 'module/seller/dashboard', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', ['as' => 'seller::dashboard','uses' => 'HomeController@dashboard',]);
    Route::get('/get-seller-growth-rate',['uses' => 'System\DashboardController@getSellerGrowthRate']);
    Route::get('/get-product-submitted-by-the-seller',['uses' => 'System\DashboardController@getProductSubmittedBySeller']);
    Route::get('/get-total-orders-by-the-seller',['uses' => 'System\DashboardController@getTotalOrdersBySeller']);
    Route::get('/get-revenue-by-category',['uses' => 'System\DashboardController@getRevenueByCategory']);
    Route::get('/get-statistic-all',['uses' => 'System\DashboardController@statisticAll']);
});

Route::group(['prefix' => 'service/seller', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/find', ['as' => 'seller::find', 'uses' => 'System\SellerController@find']);
    Route::patch('/change-status/{id}', 'System\SellerController@updateStatus');
    Route::get('/invoice', 'System\SellerController@getInvoice');
    Route::patch('/invoice/change-status/{id}', 'System\SellerController@changeInvoiceStatus');
});

Route::group(['prefix' => 'service/seller'], function () {
    Route::post('/build-invoice', 'System\SellerController@buildInvoice');
    Route::post('/build-revenue', 'System\SellerController@getRevenueLastPeriod');
    Route::get('/get-revenue', 'System\SellerController@getRevenueBySeller');
    Route::get('/statistic-revenue', 'System\SellerController@statisticRevenueBySeller');
});

Route::group(['prefix' => 'module/seller', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', [
        'as' => 'seller::index',
        'uses' => 'HomeController@indexSeller',
    ]);
    Route::get('/invoice-real', [
        'as' => 'seller::invoice',
        'uses' => 'HomeController@indexSellerInvoice',
    ]);
    Route::get('/invoice', [
        'as' => 'seller::invoice',
        'uses' => 'System\SellerController@indexFake',
    ]);
    Route::get('/fake', [
        'as' => 'seller::fake',
        'uses' => 'HomeController@indexFakeSeller',
    ]);
    Route::group(['prefix' => 'seller-statistic', 'middleware' => config('app.system_auth_middleware')], function () {
        Route::get('/', ['as' => 'seller::control.index', 'uses' => 'HomeController@statisticIndex']);
        Route::get('/new-product-every-day', ['as' => 'seller::control.index', 'uses' => 'System\SellerStatisticController@newProductEveryDay']);
    });

    Route::group(['prefix' => 'revenue'], function () {
        Route::get('/index', ['as' => 'seller::control.index', 'uses' => 'HomeController@revenueIndex']);
        Route::get('/statistic', ['as' => 'seller::control.index', 'uses' => 'System\RevenueController@statistic']);
        Route::get('/statistic/{seller_token}', ['as' => 'seller::control.index', 'uses' => 'System\RevenueController@statisticRevenueBySeller']);
    });
});

Route::group(['prefix' => 'service/seller', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/find-fake', ['as' => 'seller::find-fake', 'uses' => 'SellerController@findFakeSellers']);
    Route::delete('/remove-fake', ['as' => 'seller::remove-fake', 'uses' => 'SellerController@removeFakeSeller']);
    Route::get('/product-ids', ['as' => 'seller::get-product-ids', 'uses' => 'SellerController@getProductIdsOfSeller']);
});
Route::group(['prefix' => 'seller', 'middleware' => ['web', 'frontend']], function () {
    Route::get('/sell-your-art', 'HomeController@sellYourArt');
    Route::get('/sell-your-product', [
        'as' => 'seller::frontend::home',
        'uses' => 'Frontend\HomeController@index',
    ]);
});

Route::group(['prefix' => 'seller'], function () {
    Route::get('/signup', [
        'as' => 'seller::frontend::signup',
        'uses' => 'Frontend\HomeController@signup',
    ]);
    Route::post('/register', [
        'as' => 'seller::frontend::register',
        'uses' => 'Frontend\HomeController@register',
    ]);

    Route::post('/sync', [
        'as' => 'seller::frontend::sync',
        'uses' => 'Frontend\HomeController@sync',
    ]);

    Route::post('revenue', 'Service\RevenueController@getRevenue');
    Route::post('revenueV2', 'Service\RevenueController@getRevenueV2');
    Route::get('revenue-by-order', 'Service\RevenueController@getRevenueByOrder');
    Route::get('get-remake-revenue', 'Service\RevenueController@getRemakeOrder');

    Route::get('/remap-product', 'System\CronController@remapSellerProduct');
    Route::get('/rebuild-product-n-seller', 'System\CronController@rebuildProductNSeller');
    Route::get('/rebuild-wrong-product-n-seller', 'System\CronController@rebuildWrongProductNSeller');
});

Route::group(['prefix' => '/module/seller/seller-advertised-product', 'middleware' => config('app.system_auth_middleware')], function () {

    Route::get('/', 'System\SellerAdvertisedProductsController@list');
    Route::get('/config-commission', 'System\SellerAdvertisedProductsController@configCommission');

    Route::get('/commission', 'System\SellerAdvertisedProductsController@getCommissionConfig');
    Route::post('/commission', 'System\SellerAdvertisedProductsController@saveCommission');

    Route::put('approve-product', 'System\SellerAdvertisedProductsController@approveProduct');
    Route::put('reject-product', 'System\SellerAdvertisedProductsController@rejectProduct');

    Route::get('get-product', [
        'as' => 'seller::advertised::products',
        'uses' => 'System\SellerAdvertisedProductsController@getProducts'
    ]);
    Route::get('get-sellers', [
        'as' => 'seller::advertised::getsellers',
        'uses' => 'System\SellerAdvertisedProductsController@getSellerHasApproveRequest'
    ]);
    Route::get('count-seller-products', [
        'as' => 'seller::advertised::count-seller-products',
        'uses' => 'System\SellerAdvertisedProductsController@countSellerProducts'
    ]);
});

Route::post('/module/seller/seller-advertised-product/advertise-info', 'System\SellerAdvertisedProductsController@getAdvertiseInfo');

Route::group(['prefix' => '/module/seller/report', 'middleware' => config('app.system_auth_middleware')], function () {

    Route::get('/list-created-product', 'System\SellerReportController@listSellerProductCreatedCount');
    Route::get('/get-created-product', 'System\SellerReportController@countSellerCreatedProduct');
});

Route::group(['prefix' => '/module/seller'], function () {
    Route::post('/get-commision-by-order', 'Service\RevenueController@getCommisionEachOrder');

    Route::group(['prefix' => 'report'], function ($router) {
        Route::get('/', 'System\SellerReportController@getReportByProduct');
    });

});
