<?php

$connection = config('database.connections.mysql');
$connection['database'] = 'printerval-seller';
$connection['prefix'] = '';
config(['database.connections.printerval_seller' => $connection]);

Module::onVariable('system.menu', function (&$data) {
    if (hasPermission('module/seller')) {
        $locale = env('APP_LOCALE', '');
        if ($locale !== '') {
            $locale = '/' . $locale;
        }
        $data[] = [
            'icon' => '<i class="fa fa-grav" aria-hidden="true"></i>',
            'title' => 'Seller',
            'url' => '',
            'children' => [
                [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Dashboard',
                    'url' => $locale . '/module/seller/dashboard',
                ],
                [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Quản lý seller',
                    'url' => $locale . '/module/seller/',
                ],
                [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Seller Invoice',
                    'url' => $locale . '/module/seller/invoice-real',
                ],
                [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Quản lý Staff Seller',
                    'url' => $locale . '/module/seller/fake',
                ],
                [
                    'icon' => '<i class="fa fa-line-chart"></i>',
                    'title' => 'Advertised Products',
                    'url' => $locale . '/module/seller/seller-advertised-product',
                ],
                [
                    'icon' => '<i class="fa fa-line-chart"></i>',
                    'title' => 'Product Commission',
                    'url' => $locale . '/module/seller/seller-advertised-product/config-commission',
                ],
                [
                    'icon' => '<i class="fa fa-line-chart"></i>',
                    'title' => 'Seller Statistic',
                    'url' => $locale . '/module/seller/seller-statistic',
                ],
                [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Seller Revenue',
                    'url' => $locale . '/module/seller/revenue/index',
                ],
            ]
        ];
    }
    return $data;
});

Module::onView('title', function ($data) {
    return $data['page'] . ': This is title from Seller Module';
}, 10);

Module::onView('header', function ($data) {
    return view('seller::includes.header', [
        'moduleHeader' => getModuleOption('option.header'),
    ]);
}, 10);

Module::onView('seller-header', function () {
    return view('seller::frontend.seller-header')->render();
}, 10);
