<?php

namespace Modules\Seo\Controllers;

use App\Helpers\ApiClient;
use Illuminate\Http\Request;
use Megaads\ApifyClient\Client;
use Module;
use Google\Client as GoogleClient;
use Google\Service\SearchConsole;

class SeoController extends Controller
{

    public function __construct()
    {
        Module::onView("content", function() {
            return "This is content view from Seo Module HomeController";
        }, 5);
    }

    public function getRobotsTxt(Request $request) {
        $currentLocale = env('APP_LOCALE');
        if (!empty($currentLocale) && $currentLocale != 'us') {
            abort(404);
        }

        $lines = [
                    '#PinterestDelay',
                    'User-agent: Pinterestbot',
                    'Crawl-delay: 1.0',
                    '',
                    '#AllBots',
                    'User-agent: *',
                    'Allow: /',
                    'Disallow: */admin/*',
                    'Disallow: */admin$',
                    'Disallow: */cart/*',
                    'Disallow: */cart$',
                    'Disallow: */checkout/*',
                    'Disallow: */checkout$',
                    'Disallow: */wishlist/*',
                    'Disallow: */wishlist$',
                    'Disallow: */api/*',
                    'Disallow: */api$',
                    'Disallow: */user/*',
                    'Disallow: */user$',
                    'Disallow: */report/*',
                    'Disallow: */report$',
                    'Disallow: */sso/*',
                    'Disallow: */sso$',
                    'Disallow: */san-pham-p*',
                    'Disallow: */bought-together$',
                    'Disallow: */bought-together/*',
                    'Disallow: */browsing-history$',
                    'Disallow: */browsing-history/*',
                    'Disallow: */get-wishlist-items',
                    'Disallow: */modules$',
                    'Disallow: */modules/*',
                    'Disallow: */module$',
                    'Disallow: */module/*',
                    'Disallow: */pod$',
                    'Disallow: */pod/*',
                    'Disallow: */product$',
                    'Disallow: */product/*',
                    'Disallow: */product-control$',
                    'Disallow: */product-control/*',
                    'Disallow: /product-is-in-wishlist*',
                    'Disallow: */proxydirectory$',
                    'Disallow: */reviews$',
                    'Disallow: */reviews/*',
                    'Disallow: */service$',
                    'Disallow: */service/*',
                    'Disallow: */shipping$',
                    'Disallow: */shipping/*',
                    'Disallow: */print-suppliers/*',
                    'Disallow: */print-suppliers$',
                    'Disallow: */ticket$',
                    'Disallow: */ticket/*',
                    'Disallow: */localization$',
                    'Disallow: */localization/*',
                    'Disallow: */tickets$',
                    'Disallow: */tickets/*',
                    'Disallow: */manager$',
                    'Disallow: */manager/*',
                    'Disallow: */dashboard$',
                    'Disallow: */dashboard/*',
                    'Disallow: */warehouse$',
                    'Disallow: */warehouse/*',
                    'Disallow: */report$',
                    'Disallow: */report/*',
                    'Disallow: */reports$',
                    'Disallow: */reports/*',
                    'Disallow: */page/config',
                    'Disallow: */seo$',
                    'Disallow: */seo/*',
                    'Disallow: */comment$',
                    'Disallow: */comment/*',
                    'Disallow: */get-follow-seller$',
                    'Disallow: */get-follow-seller/*',
                    'Disallow: */search$',
                    'Disallow: */search/*',
                    'Disallow: */get-active-event$',
                    'Disallow: */get-active-event/*',
                    'Disallow: /*.json',
                    'Allow: */localization/*.svg',
                    'Allow: */modules/*.js',
                    'Allow: */modules/*.js?*',
                    'Allow: */modules/*.css?*',
                    'Allow: */modules/*.css',
                    'Allow: */modules/*.svg',
                    'Allow: */modules/*.svg?*',
                    'Allow: */modules/*.pdf',
                    'Allow: */modules/*.png',
                    'Allow: */reviews/*.gif',
                    'Allow: */bought-together/*.js',
                    'Allow: */pod/*.jpg',
                    'Allow: */pod/*.png',
                    'Allow: */product/*.xml',
                    '',
                    '#Googlebot-Image',
                    'User-agent: Googlebot',
                    'Disallow:',
                    'Disallow: */admin/*',
                    'Disallow: */admin$',
                    'Disallow: */cart/*',
                    'Disallow: */cart$',
                    'Disallow: */checkout/*',
                    'Disallow: */checkout$',
                    'Disallow: */wishlist/*',
                    'Disallow: */wishlist$',
                    'Disallow: */api/*',
                    'Disallow: */api$',
                    'Disallow: */user/*',
                    'Disallow: */user$',
                    'Disallow: */report/*',
                    'Disallow: */report$',
                    'Disallow: */sso/*',
                    'Disallow: */sso$',
                    'Disallow: */san-pham-p*',
                    'Disallow: */bought-together$',
                    'Disallow: */bought-together/*',
                    'Disallow: */browsing-history$',
                    'Disallow: */browsing-history/*',
                    'Disallow: */get-wishlist-items',
                    'Disallow: */modules$',
                    'Disallow: */modules/*',
                    'Disallow: */module$',
                    'Disallow: */module/*',
                    'Disallow: */pod$',
                    'Disallow: */pod/*',
                    'Disallow: */product$',
                    'Disallow: */product/*',
                    'Disallow: */product-control$',
                    'Disallow: */product-control/*',
                    'Disallow: /product-is-in-wishlist*',
                    'Disallow: */proxydirectory$',
                    'Disallow: */reviews$',
                    'Disallow: */reviews/*',
                    'Disallow: */service$',
                    'Disallow: */service/*',
                    'Disallow: */shipping$',
                    'Disallow: */shipping/*',
                    'Disallow: */print-suppliers/*',
                    'Disallow: */print-suppliers$',
                    'Disallow: */ticket$',
                    'Disallow: */ticket/*',
                    'Disallow: */localization$',
                    'Disallow: */localization/*',
                    'Disallow: */tickets$',
                    'Disallow: */tickets/*',
                    'Disallow: */manager$',
                    'Disallow: */manager/*',
                    'Disallow: */dashboard$',
                    'Disallow: */dashboard/*',
                    'Disallow: */warehouse$',
                    'Disallow: */warehouse/*',
                    'Disallow: */report$',
                    'Disallow: */report/*',
                    'Disallow: */reports$',
                    'Disallow: */reports/*',
                    'Disallow: */page/config',
                    'Disallow: */seo$',
                    'Disallow: */seo/*',
                    'Disallow: */comment$',
                    'Disallow: */comment/*',
                    'Disallow: */get-follow-seller$',
                    'Disallow: */get-follow-seller/*',
                    'Disallow: */search$',
                    'Disallow: */search/*',
                    'Disallow: */get-active-event$',
                    'Disallow: */get-active-event/*',
                    'Disallow: /*.json',
                    'Allow: */localization/*.svg',
                    'Allow: */modules/*.js',
                    'Allow: */modules/*.js?*',
                    'Allow: */modules/*.css?*',
                    'Allow: */modules/*.css',
                    'Allow: */modules/*.svg',
                    'Allow: */modules/*.svg?*',
                    'Allow: */modules/*.pdf',
                    'Allow: */modules/*.png',
                    'Allow: */reviews/*.gif',
                    'Allow: */bought-together/*.js',
                    'Allow: */pod/*.jpg',
                    'Allow: */pod/*.png',
                    'Allow: */product/*.xml',
                    'User-agent: Googlebot-image',
                    'Disallow:',
                    '',
                    'Sitemap: ' . url('sitemap-indexing.xml'),
        ];

        ob_clean();
        return response(implode(PHP_EOL, $lines), 200)->header('Content-Type', 'text/plain');
    }

    public function pingSiteMap(Request $request) {
        $client = new GoogleClient();
        $client->setAuthConfig(base_path('config/printerval-analytic.json'));
        $client->addScope(SearchConsole::WEBMASTERS);

        $service = new SearchConsole($client);
        try {
            $service->sitemaps->submit(url('/'), $request->input('url', url('sitemap-indexing.xml')));
            $retVal = [
                'status' => 'successful',
                'message' => 'Sitemap submitted successfully!'
            ];
        } catch (\Exception $e) {
            $retVal = [
                'status' => 'failed',
                'message' => 'An error occurred: ' . $e->getMessage()
            ];
        }

        return response()->json($retVal);
    }

    public function generateRss()
    {
        set_time_limit(3600);

        //Product
        $query = ApiClient::buildClient("category");
        $query->filter("is_hidden", Client::SELECTION_EQUAL, 0);
        $query->filter("type", Client::SELECTION_EQUAL, 'PRODUCT');
        $query->pageSize(100);
        $result = $query->get();
        $storeName = getOption('general.store_name');
        $themeName = env('THEME');
        if($result['status'] == 'successful'){
            foreach ($result['result'] as $category) {
                $query = ApiClient::buildClient("product/filter");
                $query->filter("status", Client::SELECTION_EQUAL, 'ACTIVE');
                $query->filter("category_id", Client::SELECTION_EQUAL, $category['id']);
                $query->filter("page_size", Client::SELECTION_EQUAL, '20');
                $resultProduct = $query->get();
                $retVal = [
                    'siteDomain' => env('APP_URL'),
                    'items' => $resultProduct['result'],
                    'category' => $category,
                    'storeName' => $storeName,
                    'themeName' => $themeName,
                    'type' => 'product'
                ];
                $content = view('rss', $retVal)->render();
                file_put_contents(public_path('rss/' . $category['slug'] . '.xml'), $content);
            }
        }

        //Post
        $query = ApiClient::buildClient("category");
        $query->filter("is_hidden", Client::SELECTION_EQUAL, 0);
        $query->filter("type", Client::SELECTION_EQUAL, 'POST');
        $query->pageSize(100);
        $result = $query->get();
        $storeName = getOption('general.store_name');
        $themeName = env('THEME');
        if($result['status'] == 'successful'){
            foreach ($result['result'] as $category) {
                $query = ApiClient::buildClient("post");
                $query->filter("status", Client::SELECTION_EQUAL, 'ACTIVE');
                $query->filter("category_id", Client::SELECTION_EQUAL, $category['id']);
                $query->pageSize(20);
                $resultPost = $query->get();
                $retVal = [
                    'siteDomain' => env('APP_URL'),
                    'items' => $resultPost['result'],
                    'category' => $category,
                    'storeName' => $storeName,
                    'themeName' => $themeName,
                    'type' => 'post'
                ];
                $content = view('rss', $retVal)->render();
                file_put_contents(public_path('rss/' . $category['slug'] . '.xml'), $content);
            }
        }

        return response()->json(['status' => 'successful']);
    }

}
