<?php
namespace Modules\Seo\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PHPExcel_IOFactory;

class TextLinkFooterController extends Controller {

    public function index() {
        return view('seo::admin.text-link-footer.index');
    }

    public function find(Request $request) {
        $retVal = ['status' => 'successful', 'result' => []];

        $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->select('value')->first();
        if ($textLinkFooterData) {
            if (!empty($textLinkFooterData->value)) {
                $retVal['result'] = json_decode($textLinkFooterData->value);
            }
        }

        return response()->json($retVal);
    }

    public function save(Request $request) {
        $retVal = ['status' => 'fail', 'message' => 'Error!'];
        
        if (!empty($request->get('data'))) {
            $dataToSave = json_encode($request->get('data'));
        } else {
            $dataToSave = null;
        }

        $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->exists();
        if (!$textLinkFooterData) {
            DB::table('option')->insert([
                'name' => 'Text Link Footer',
                'key' => 'text_link_footer',
                'value' => $dataToSave,
                'type' => 'json'
            ]);
        } else {
            $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->update([
                'value' => $dataToSave
            ]);
        }

        $retVal['status'] = 'successful';
        $retVal['message'] = 'successful';

        return response()->json($retVal);
    }

    public function import(Request $request) {
        $retVal = ['status' => 'fail', 'message' => 'Error!'];
        
        if ($request->hasFile('excelFile')) {
            
            $objPHPExcel = PHPExcel_IOFactory::load($request->file('excelFile'));
            $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
            $headings = array_shift($sheetData);

            $dataSave = [];
            $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->select('value')->first();
            if ($textLinkFooterData) {
                if (!empty($textLinkFooterData->value)) {
                    $dataSave = json_decode($textLinkFooterData->value);
                }
            }

            $messageError = '';

            foreach ($sheetData as $key => $row) {
                $items = array_combine($headings, $row);

                if (empty($items['name']) && empty($items['url'])) {
                    continue;
                }

                if (empty($items['name'])) {
                    $messageError = 'Vui lòng nhập name ở dòng ' . ($key + 1);
                    break;
                }

                if (empty($items['url'])) {
                    $messageError = 'Vui lòng nhập url ở dòng ' . ($key + 1);
                    break;
                }

                $item = [
                    'name' => $items['name'],
                    'url' => $items['url']
                ];

                $isUpdate = false;

                foreach ($dataSave as &$obj) {
                    if (!empty($obj->name) && !empty($item["name"])) {
                        if ($obj->name == $item["name"]) {
                            $isUpdate = true;
                            $obj = $item;
                        }
                    }
                }

                if (!$isUpdate) {
                    $dataSave[] = $item;
                }
            }

            if ($messageError != '') {
                $retVal['message'] = $messageError;
            } else {
                $retVal['status'] = 'successful';
                $retVal['message'] = 'successful';

                if (!empty($dataSave)) {
                    $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->exists();
                    if (!$textLinkFooterData) {
                        DB::table('option')->insert([
                            'name' => 'Text Link Footer',
                            'key' => 'text_link_footer',
                            'value' => json_encode($dataSave),
                            'type' => 'json'
                        ]);
                    } else {
                        $textLinkFooterData = DB::table('option')->where('key', '=', 'text_link_footer')->update([
                            'value' => json_encode($dataSave)
                        ]);
                    }
                }
            }
        }

        return response()->json($retVal);
    }

}



?>