<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbKeywordLinkTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('keyword_link')) {
            Schema::create('keyword_link', function (Blueprint $table) {
                $table->increments('id');
                $table->string('keyword', 255)->collation('utf8_unicode_ci');
                $table->string('link', 2083)->collation('utf8_unicode_ci');
                $table->string('title', 2083);
                $table->enum('status', ['enable', 'disable', 'deleted'])->default('enable');
                $table->tinyInteger('auto')->nullable()->default(1);
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->integer('category_id')->nullable();
                $table->integer('is_processing')->nullable();
                $table->index('keyword', 'keyword');

                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('keyword_link');
    }
}
