<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbTagConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('sb_tag_config')) {
            Schema::create('sb_tag_config', function (Blueprint $table) {
                $table->increments('id');
                $table->enum('type', ['CATEGORY', 'TAG'])->nullable();
                $table->integer('refer_id');
                $table->string('refer_name', 255);
                $table->string('refer_url', 2048);
                $table->enum('related_type', ['CATEGORY', 'TAG'])->nullable();
                $table->integer('related_id');
                $table->string('related_name', 255);
                $table->string('related_url', 2048);
                $table->string('image_url', 2048);
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sb_tag_config');
    }
}
