<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbMetaDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('sb_meta_data')) {
            Schema::create('sb_meta_data', function (Blueprint $table) {
                $table->increments('id');
                $table->string('url', 255)->nullable();
                $table->string('meta_title', 1000)->nullable();
                $table->string('meta_keywords', 1000)->nullable();
                $table->text('meta_description')->nullable();
                $table->longText('content')->nullable();
                $table->longText('content_footer')->nullable();
                $table->string('heading', 255)->nullable();
                $table->string('canonical', 255)->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->unique('url', 'url');

                $table->charset = 'utf8';
                $table->collation = 'utf8_unicode_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sb_meta_data');
    }
}
