<?php
namespace Modules\Seo\Models;

use Illuminate\Database\Eloquent\Model;

class Hreflang extends Model {

    protected $table = "hreflang_config";
    protected $primaryKey = "id";
    protected $fillable = array('url', 'content');

    public function getContentAttribute() {
        if (!empty($this->attributes['content'])) {
            $content = json_decode($this->attributes['content'], true);
            return $content;
        } else {
            return (object) [];
        }
    }

}

?>
