<?php

namespace Modules\Seo\Models;

use  Illuminate\Database\Eloquent\Model;

class ProductSkuValue extends Model
{
    protected $table = 'product_sku_value';

    protected $fillable = [
        'sku_id',
        'variant_id',
        'variant_option_id',
        'product_id',
    ];

    public function variant() {
        return $this->hasOne(ProductVariant::class, 'id', 'variant_id');
    }

    public function variantOption() {
        return $this->hasOne(ProductVariantOption::class, 'id', 'variant_option_id');
    }
}
