<?php

namespace Modules\Seo\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model
{
    protected $table = 'users';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'image_avatar', 'image_background', 'slug', 'token', 'seller_token', 'role', 'status'
    ];
    
    public function products ()
    {
        return $this->hasMany(Product::class, 'id', 'actor_id');

    }
    
}
