<?php 
namespace Modules\Seo\Providers;

use Illuminate\Routing\Route;
use Illuminate\Support\ServiceProvider;
use Modules\Seo\Validators\CustomValidator;

class SeoServiceProvider extends ServiceProvider 
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Register middle for inject html response
        $this->registerMiddleware('Modules\Seo\Middlewares\SeoRedirectMiddleware');

        Route::$validators = array_merge([
            $this->app->make(CustomValidator::class),
        ], Route::getValidators());
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    protected function registerMiddleware($middleware) {
        $kernel = $this->app['Illuminate\Contracts\Http\Kernel'];
        $kernel->pushMiddleware($middleware);
    }
}