system.controller("FaqController", FaqController);

system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format("DD/MM/YYYY");
    };
});

function FaqController($rootScope, $scope, $http, Upload) {
    $scope.filters = {};
    $scope.items = [];
    $scope.ajaxFindRequest = null;
    $scope.titleModal = "Create faq";
    $scope.pagesCount = 0;
    $scope.faqs = [];
    $scope.uploading = false;
    $scope.statuses = {
        ACTIVE: 'ACTIVE',
        INACTIVE: 'INACTIVE',
    };

    this.initialize = function () {
        // $scope.getFaqs();
        initalFilters();
        resetFilter();
    };

    $scope.reset = function () {
        $scope.isSaving = false;
        $scope.isFinding = false;
        resetFilter();
    };

    $scope.keypressFilter = function (event) {
        if (event.keyCode === 13) {
            $scope.find(true);
        }
    };

    resetFilter = function () {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = "";

        $scope.find(true);
    };

    initalFilters = function () {
        $scope.filters.keyword = "";
    };

    $scope.find = function (refresh = false) {
        $scope.filters.page_size = 20;
        if ($scope.ajaxFindRequest === null) {
            if (refresh) {
                $scope.filters.page_id = 0;
            }
            $scope.isShowHideLoading(true);

            const url = $scope.buildUrl("/seo/faq/find");

            $scope.ajaxFindRequest = $http.get(url).then(function (response) {
                $scope.ajaxFindRequest = null;
                $scope.isSaving = false;

                if (response.data.status === "successful") {
                    $scope.items = response.data.items;
                    $scope.isShowHideLoading(false);
                    $scope.pagesCount = response.data.pagesCount;
                }
            });
        }
    }

    $scope.buildUrl = function (prefixUrl) {
        let url =
            prefixUrl +
            "?page_id=" + $scope.filters.page_id +
            "?page_size=" + $scope.filters.page_size;

        if ($scope.filters.keyword) {
            url += "&keyword=" + $scope.filters.keyword;
        }

        return url;
    };

    buildFilter = function () {
        var retVal = {};
        if ($scope.filters.keyword != "") {
            retVal.keyword = $scope.filters.keyword;
        }
        if (typeof $scope.filters.status != "undefined" && typeof $scope.filters.status.code != "undefined" && $scope.filters.status.code != "") {
            retVal.status = $scope.filters.status.code;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal.join();
    };

    $scope.isShowHideLoading = function (val) {
        $scope.isShowLoading = val;
    };

    $scope.openModal = (faq, title = "Edit faq") => {
        $scope.faq = angular.copy(faq);
        $scope.titleModal = title;
        $("#modalFaq").modal();
    };

    $scope.create = () => {
        let faq = {};
        $scope.titleModal = "Create faq";
        $scope.openModal(faq, "Create faq");
    };

    $scope.delete = (faq) => {
        if (confirm("Are you sure you want to delete: '" + faq.question + "' ?")) {
            $scope.isShowHideLoading(true);
            $scope.ajaxFindRequest = $http.post("/seo/faq/delete", { id: faq.id }).then(function (response) {
                $scope.ajaxFindRequest = null;
                $scope.isShowHideLoading(false);

                if (response.data.status === "successful") {
                    $scope.find();
                }
            });
        }
    };

    $scope.save = () => {
        if ($scope.ajaxFindRequest === null) {
            $scope.isShowHideLoading(true);
            let validate = $scope.validate();
            console.log('check', validate);
            if (validate) {
                $scope.ajaxFindRequest = null;
                $scope.isSaving = false;
                $scope.isShowHideLoading(false);
                return;
            }
            let data = $scope.buildData();
            $scope.ajaxFindRequest = $http.post("/seo/faq/save", data).then(function (response) {
                $scope.ajaxFindRequest = null;
                $scope.isSaving = false;
                $scope.isShowHideLoading(false);

                if (response.data.status === "successful") {
                    $scope.find();
                    $("#modalFaq").modal("hide");
                    toastr.success("Faq saved successfully");
                }
            });
        }
    }

    $scope.buildData = function () {
        let result = {
            question: $scope.faq.question,
            answer: $scope.faq.answer,
            status: $scope.faq.status
        };
        if ($scope.faq.id) {
            result.id = $scope.faq.id;
        }
        return result;
    }

    $scope.validate = () => {
        let retVal = false;

        if (typeof $scope.faq.question === "undefined" || $scope.faq.question == "") {
            toastr.error("Please type question!");
            retVal = true;
        }

        if (typeof $scope.faq.answer === "undefined" || $scope.faq.answer == "") {
            toastr.error("Please type answer!");
            retVal = true;
        }

        return retVal;
    }

    this.initialize();
}