system.controller("HreflangController", HreflangController);

function HreflangController ($rootScope, $scope, $http, $window, $timeout, Upload) {

    $scope.locales = {};
    $scope.filters = { page_id: 0 };
    $scope.item = {};
    $scope.pageId = 0;
    $scope.pagesCount = 0;
    $scope.excelFile = null;
    $scope.isSaving = false;
    $scope.currentUrl = new URL($window.location.href);
    $scope.currentLocale = (CURRENT_LOCALE != '') ? CURRENT_LOCALE : 'us';

    $scope.init = function () {
        if (locales) {
            var localesObj = JSON.parse(locales);
            for (var key in localesObj) {
                $scope.locales[key] = '';
            }
        }

        $scope.find();
    }

    $scope.downloadTemplate = function () {
        $window.open('/modules/seo/files/Hreflang_Template.xlsx', '_blank').focus();
    }

    $scope.handleUpload = function (excelFile) {
        if (excelFile) {
            var locales = Object.keys($scope.locales)
            if (locales.length != 0) { // localizations
                locales.forEach(function (locale) {
                    Upload.upload({
                        url: $window.location.origin + `/${locale}/seo/hreflang/import?ignore_localization=1`,
                        data: { excelFile: excelFile }
                    }).then(function (response) {
                        if (response.data.status == "successful") {
                            toastr.success(`Import thành công ${response.data.affectedRows} bản ghi cho thị trường ${locale.toUpperCase()}.`);
                            console.log($scope.currentLocale, locale)
                            if ($scope.currentLocale == locale) {
                                $scope.find();
                            }
                        } else {
                            toastr.error(`${locale.toUpperCase()}. ` + response.data.message);
                        }
                    }, function (error) {
                        toastr.error(`Có lỗi xảy ra trong quá trình Import cho thị trường ${locale.toUpperCase()}.`);
                    });
                });
            } else {
                Upload.upload({
                    url: `/seo/hreflang/import`,
                    data: { excelFile: excelFile }
                }).then(function (response) {
                    if (response.data.status == "successful") {
                        toastr.success(`Import thành công ${response.data.affectedRows} bản ghi.`);
                        $scope.find();
                    } else {
                        toastr.error(`Có lỗi xảy ra trong quá trình Import. ` + response.data.message);
                    }
                }, function (error) {
                    toastr.error(`Có lỗi xảy ra trong quá trình Import.`);
                });
            }
        }
    }

    $scope.create = function () {
        $scope.item = {
            content: angular.copy($scope.locales)
        };
        $timeout(function () {
            $('#modal-hreflang').modal('show');
        })
    } 

    $scope.myEnter = function ($event) {
        if ($event.keyCode == 13 || $event.which == 13) {
            $scope.pageId = 0;
            $scope.find();
        }
    }

    $scope.edit = function (item) {
        var tempItem =  angular.copy(item);
        tempItem.content = Object.assign(angular.copy($scope.locales), item.content);
        $scope.item = tempItem;
        $timeout(function () {
            $('#modal-hreflang').modal('show');
        })
    } 

    $scope.delete = function (item, $index) {
        var check = confirm(`Bạn có chắc chắn muốn xóa Hreflang này không?\n${item.url}`);
        if (check) {
            var data = { content: $scope.buildContent(item.content) };
            var locales = Object.keys($scope.locales)
            if (locales.length != 0) { // localizations
                locales.forEach(function (locale) {
                    $http.post($window.location.origin + `/${locale}/seo/hreflang/delete?ignore_localization=1`, data).then(function (response) {
                        if (response.data.status == 'successful') {
                            toastr.success(`Xóa thành công Hreflang tại thị trường ${locale.toUpperCase()}.`);
                            if ($scope.currentLocale == locale) {
                                $scope.items.splice($index, 1);
                            }
                        } else {
                            toastr.error(`${locale.toUpperCase()}. ` + response.data.message);
                        }
                    }, function (error) {
                        toastr.error(`Có lỗi xảy ra trong quá trình Xóa Hreflang tại thị trường ${locale.toUpperCase()}.`);
                    });
                });
            } else {
                $http.post('/seo/hreflang/delete', item).then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Xóa thành công Hreflang.');
                        $scope.items.splice($index, 1);
                    } else {
                        toastr.error(response.data.message);
                    }
                }, function (error) {
                    toastr.error('Có lỗi xảy ra trong quá trình Xóa Hreflang. Xin vui lòng thử lại.');
                });
            }
        }
    }

    $scope.buildContent = function (content) {
        var buildContent = {};
        
        for (var k in content) {
            if (content[k]) {
                try {
                    var parseUrl = new URL(content[k]);
                    buildContent[k] = parseUrl.pathname + parseUrl.search;
                } catch (e) {
                    buildContent[k] = content[k];
                }
            }
        }
        return buildContent;
    }

    $scope.save = function () {
        var buildContent = $scope.buildContent($scope.item.content);
        
        if (Object.keys(buildContent).length == 0) {
            toastr.error('Mời nhập ít nhất một link Hreflang.');
        }

        let data = { content: buildContent };
        $scope.isSaving = true;

        var locales = Object.keys($scope.locales)
        if (locales.length != 0) { // localizations
            locales.forEach(function (locale) {
                $http.post($window.location.origin + `/${locale}/seo/hreflang/save?ignore_localization=1`, data).then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success(`Lưu thành công Hreflang tại thị trường ${locale.toUpperCase()}.`);
                        if ($scope.currentLocale == locale) {
                            if (data.id) {
                                for (var i in $scope.items) {
                                    if ($scope.items[i].id == response.data.result.id) {
                                        $scope.items[i] = $scope.buildItem(response.data.result);
                                        break;
                                    }
                                }
                            } else {
                                $scope.items.unshift($scope.buildItem(response.data.result));
                            }
                            $scope.isSaving = false;
                            $timeout(function () {
                                $('#modal-hreflang').modal('hide');
                            });
                        }
                    } else {
                        toastr.error(`${locale.toUpperCase()}: ` + response.data.message);
                    }
                }, function (error) {
                    $scope.isSaving = false;
                    toastr.error(`Có lỗi xảy ra trong quá trình Lưu Hreflang tại thị trường ${locale.toUpperCase()}.`);
                });
            });
        } else {
            $http.post('/seo/hreflang/save', data).then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Lưu thành công Hreflang.');
                    if (data.id) {
                        for (var i in $scope.items) {
                            if ($scope.items[i].id == response.data.result.id) {
                                $scope.items[i] = $scope.buildItem(response.data.result);
                                break;
                            }
                        }
                    } else {
                        $scope.items.unshift($scope.buildItem(response.data.result));
                    }
                    $scope.isSaving = false;
                    $timeout(function () {
                        $('#modal-hreflang').modal('hide');
                    });
                } else {
                    toastr.error(response.data.message);
                }
            }, function (error) {
                $scope.isSaving = false;
                toastr.error('Có lỗi xảy ra trong quá trình Lưu hreflang. Xin vui lòng thử lại.');
            });
        }
    }

    $scope.find = function () {
        var filters = angular.copy($scope.filters);
        filters.page_size = 30;
        if (filters.url) {
            try {
                var parseUrl = new URL(filters.url);
                filters.url = parseUrl.pathname + parseUrl.search;
            } catch (e) {}
        }

        $http.get('/seo/hreflang/find', { params: filters }).then(function (response) {
            if (response.data.status == 'successful') {
                var items = response.data.result;
                for (var i in items) {
                    items[i] = $scope.buildItem(items[i]);
                }
                $scope.items = items;
                $scope.pagesCount = parseInt(response.data.meta.page_count || 0);
            } else {
                toastr.error(response.data.message);
            }
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy hreflang. Xin vui lòng thử lại.');
        });
    }

    $scope.buildItem = function (item) {
        item.url = $scope.currentUrl.origin + item.url;
        for (var k in item.content) {
            item.content[k] = $scope.currentUrl.origin + item.content[k];
        }
        return item;
    }

    $scope.init();
}