system.controller("TextLinkFooterController", TextLinkFooterController);

function TextLinkFooterController ($rootScope, $scope, $http, $window, $timeout, Upload) {

    $scope.item = {
        name: '',
        value: ''
    };
    $scope.itemIndex = null;
    $scope.isSaving = false;
    $scope.type = 'create';

    $scope.init = function () {
        $scope.find();
    }

    $scope.create = function () {
        $scope.type = 'create';
        $scope.item = {
            name: '',
            value: ''
        };
        $scope.itemIndex = null;
        $timeout(function () {
            $('#modal-text-link-footer').modal('show');
        })
    } 

    $scope.edit = function (item, $index) {
        $scope.type = 'update';
        $scope.item =  angular.copy(item);
        $scope.itemIndex = $index;
        $timeout(function () {
            $('#modal-text-link-footer').modal('show');
        })
    } 

    $scope.delete = function (item, $index) {
        var check = confirm(`Bạn có chắc chắn muốn xóa Text Link Footer này không?\n${item.name} : ${item.url}`);
        if (check) {
            $scope.type = 'delete';
            $scope.item =  angular.copy(item);
            $scope.itemIndex = $index;
            $scope.save();
        }
    }

    $scope.save = function () {
        var itemsToSave = angular.copy($scope.items);
        var check = true;
        var message = 'Lưu thành công Text Link Footer.';

        if (!$scope.item) {
            check = false;
            toastr.error('Có lỗi xảy ra trong load dữ liệu Text Link Footer. Xin vui lòng thử lại.');
        }

        if (($scope.type == 'create' || $scope.type == 'update') && $scope.item && !validate($scope.item)) {
            check = false;
            toastr.error('Name và Url không được để trống!.');
        }

        if (!check) {
            return;
        }

        if ($scope.type == 'create') {
            if (typeof $scope.item.value != "undefined") {
                delete $scope.item.value;
            }
            itemsToSave.push($scope.item);
        } else if ($scope.type == 'update') {
            for (let index = 0; index < itemsToSave.length; index++) {
                if ($scope.itemIndex != null && index == $scope.itemIndex) {
                    itemsToSave[index].name = $scope.item.name;
                    itemsToSave[index].url = $scope.item.url;
                }
            }
        } else {
            message = 'Xoá thành công Text Link Footer.';
            for (let index = 0; index < itemsToSave.length; index++) {
                if ($scope.itemIndex != null && index == $scope.itemIndex) {
                    itemsToSave.splice(index, 1);
                }
            }
        }

        var data = {
            data: itemsToSave.length > 0 ? itemsToSave : null
        };

        $http.post('/seo/text-link-footer/save', data).then(function (response) {
            if (response.data.status == 'successful') {
                toastr.success(message);
                $scope.find();
                $scope.isSaving = false;
                $timeout(function () {
                    $('#modal-text-link-footer').modal('hide');
                });
            } else {
                toastr.error(response.data.message);
            }
        }, function (error) {
            $scope.isSaving = false;
            toastr.error('Có lỗi xảy ra trong quá trình Lưu Text Link Footer. Xin vui lòng thử lại.');
        });
    }

    $scope.find = function () {
        $http.get('/seo/text-link-footer/find').then(function (response) {
            if (response.data.status == 'successful') {
                var items = response.data.result;
                $scope.items = items;
            } else {
                toastr.error(response.data.message);
            }
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình Lấy hreflang. Xin vui lòng thử lại.');
        });
    }

    $scope.downloadTemplate = function () {
        $window.open('/modules/seo/files/TextLinkFooter_Template.xlsx', '_blank').focus();
    }

    $scope.handleUpload = function (excelFile) {
        if (excelFile) {
            Upload.upload({
                url: `/seo/text-link-footer/import`,
                data: { excelFile: excelFile }
            }).then(function (response) {
                if (response.data.status == "successful") {
                    toastr.success(`Import thành công.`);
                    $scope.find();
                } else {
                    toastr.error(`Có lỗi xảy ra trong quá trình Import. ` + response.data.message);
                }
            }, function (error) {
                toastr.error(`Có lỗi xảy ra trong quá trình Import.`);
            });
        }
    }

    function validate (item) {
        if (typeof item.name != 'undefined' && typeof item.url != 'undefined' && item.name != '' && item.url != '') {
            return true;
        }
        return false;
    }

    $scope.init();
}