const pluginUrl = document.location.toString().replace(/\/[^/]*$/, '/meta-data');

tinymce.PluginManager.add('customfaq', function (editor) {
    var version = '1.1'; // Define your plugin version here

    editor.addButton('customfaq', {
        text: 'FAQ',
        icon: 'help',
        onclick: showDialog
    });

    function showDialog() {
        var win, contentEditor = {
            output: null,
            faq: {
                question: '',
                answer: ''
            }
        };

        win = editor.windowManager.open(
            {
                title: "FAQ",
                spacing: 10,
                padding: 10,
                width: 800,
                height: 600,
                url: pluginUrl + '/dialog-faq',
                buttons: [
                    {
                        text: "Save FAQ", onclick: function () {
                            editor.insertContent('[faq]');
                            editor.insertContent('[question]' + contentEditor.faq.question + '[/question]');
                            editor.insertContent('[answer]' + contentEditor.faq.answer + '[/answer]');
                            editor.insertContent('[/faq]');
                            win.close();
                        }
                    },
                    {
                        text: "Cancel", onclick: function () {
                            win.close();
                        }
                    }
                ]
            },
            contentEditor
        );
    }

    return {
        getMetadata: function () {
            return  {
                name: "Custom FAQ",
                url: pluginUrl,
                version: version
            };
        }
    };
});