tinymce.PluginManager.add('excelfaq', function (editor) {
    var version = '1.1'; // Define your plugin version here
    editor.addButton('excelfaq', {
        text: 'Import FAQ',
        icon: 'upload',
        onclick: function() {
            var input = document.createElement('input');
            input.type = 'file';
            input.accept = '.xls,.xlsx';
            input.onchange = function(event) {
                var file = event.target.files[0];
                var reader = new FileReader();
                reader.onload = function(event) {
                    var data = new Uint8Array(event.target.result);
                    var workbook = XLSX.read(data, {type: 'array'});
                    var worksheet = workbook.Sheets[workbook.SheetNames[0]];
                    var html = XLSX.utils.sheet_to_html(worksheet);
                    var parser = new DOMParser();
                    var doc = parser.parseFromString(html, 'text/html');
                    var rows = doc.querySelectorAll('table tr');

                    var dataFaq = Array.from(rows).slice(1).map(row => {
                        var cells = row.querySelectorAll('td');
                        return {
                            question: cells[0].textContent,
                            answer: cells[1].textContent
                        };
                    });

                    var result = '';
                    dataFaq.forEach(faq => {
                        const template = '[faq][question]' + faq.question + '[/question][answer]' + faq.answer + '[/answer][/faq]';
                        result += template;
                    });

                    editor.insertContent(result);
                };
                reader.readAsArrayBuffer(file);
            };
            input.click();
        }
    });

    return {
        getMetadata: function () {
            return  {
                name: "Import FAQ",
                version: version
            };
        }
    };
});