tinymce.PluginManager.add('newsList', function (editor, url) {
    var tinyRequest, tinyTimeout;
    editor.settings.autoEmbedData.listTags = [];

    var dropDownTags = function (options) {
        return {
            type: 'listbox',
            name: 'listTags',
            multiline: true,
            label: 'Kết quả tìm kiếm Tags',
            values: (options) ? options : [{text: 'Không xác định', value:''}],
            onselect: function(e) {
                if (!Array.isArray(editor.settings.autoEmbedData.listTags)) {
                    editor.settings.autoEmbedData.listTags = [];
                }
                if (this.value() != '' && !isNaN(this.value()) && editor.settings.autoEmbedData.listTags.indexOf(this.value()) < 0) {
                    editor.settings.autoEmbedData.listTags.push(this.value());
                }
            }
        };
    }

    editor.addButton('newsList', {
        text: 'Nhúng bài viết',
        icon: false,
        onclick: function () {
            var window = editor.windowManager.open({
                title: 'Chọn bài viết chứa các Tags',
                width: 800,
                height: 400,
                body: [
                    {
                        type: 'textbox',
                        name: 'limitNews',
                        label: 'Số bài viết được hiển thị',
                        autofocus: true,
                        onkeyup: function(e) {
                            if (this.value() != '' && !isNaN(this.value()))
                                editor.settings.autoEmbedData.limits = this.value();
                        }
                    },
                    {
                        type: 'textbox',
                        name: 'numberColumns',
                        label: 'Số cột hiển thị',
                        onkeyup: function(e) {
                            if (this.value() != '' && !isNaN(this.value()))
                                editor.settings.autoEmbedData.cols = this.value();
                        }
                    },
                    {
                        type: 'textbox',
                        name: 'searchTags',
                        label: 'Tìm kiếm Tags',
                        onkeyup: function(e) {
                            var searchValue = this.value();
                            if (searchValue || searchValue != '') {
                                if (typeof tinyTimeout != "undefined") {
                                    clearTimeout(tinyTimeout);
                                }
                                tinyTimeout = setTimeout(function () {
                                    if (typeof tinyRequest != "undefined") {
                                        tinyRequest.abort();
                                    }
                                    
                                    tinyRequest = $.ajax({
                                        url: "/system/tag/find",
                                        type: "post",
                                        dataType: "json",
                                        data: {
                                            title: searchValue,
                                            page_size: 50
                                        },
                                        success: function(response) {
                                            if (response.status == "successful") {
                                                listbox = window.find('#listTags');
                                                formItem = listbox.parent();
                                                listbox.remove();

                                                if (response.tags && response.tags.length != 0) {
                                                    var tags = [{text: 'Không xác định', value:''}];
                                                    response.tags.forEach(function (item) {
                                                        tags.push({text: item.title, value: item.id });
                                                    });
                                                }
                                                formItem.append(dropDownTags(tags)); //reinit 
                                            }
                                        }
                                    });
                                }, 400);
                            }
                        }
                    },
                    dropDownTags()
                ],
                onsubmit: function (e) {
                    var messageFail = '';
                    if (!editor.settings.autoEmbedData.listTags || editor.settings.autoEmbedData.listTags.length == 0) {
                        messageFail += '\nMời chọn Tag tin tức.';
                    }
                    if (!editor.settings.autoEmbedData.limits || editor.settings.autoEmbedData.listTags.limits == "") {
                        messageFail += '\nMời chọn Số bài viết được hiển thị.';
                    }
                    if (!editor.settings.autoEmbedData.cols || editor.settings.autoEmbedData.listTags.cols == "") {
                        messageFail += '\nMời chọn Số cột hiển thị.';
                    }
                    if (messageFail && messageFail != '') {
                        alert('Dữ liệu không hợp lệ. Xin vui lòng kiểm tra lại\n' + messageFail);
                        return false;
                    }

                    editor.insertContent(`[news limit="${editor.settings.autoEmbedData.limits}" col="${editor.settings.autoEmbedData.cols}" tags="${editor.settings.autoEmbedData.listTags.join(',')}" /]`);
                },
                onclose: function (e) {
                    editor.settings.autoEmbedData = {};
                    editor.windowManager.close();
                }
            });
        }
    });

});