
tinymce.PluginManager.add('productList', function (editor, url) {
    var self = this, button, selectedProducts, tinyRequest;
    editor.settings.listProducts = [{text: 'Chưa có dữ liệu', value:''}];
    editor.settings.listSeletedProduct = [{type: 'label', text: ''}];
    editor.settings.isAutoEmbedProduct = false;
    editor.settings.autoEmbedData = {};
    var currentTime = new Date();
    tinyMCE.DOM.loadCSS(url + '/css/productlist.min.css?v=' + currentTime.getTime());

    function getValues(){
        return editor.settings.listProducts;
    }

    function getListSelected(){
        return editor.settings.listSeletedProduct;
    }

    // Add a button that opens a window
    editor.addButton('productList', {
        text: 'Nhúng sản phẩm',
        icon: false,
        onclick: function () {
            // Open window
            var window = editor.windowManager.open({
                title: 'Nhập danh sách sản phẩm',
                width: 800,
                height: 240,
                buttons: [{
                    text: 'Thêm vào nội dung',
                    classes: 'widget btn primary first abs-layout-item',
                    id: 'uniqueid',
                    disabled: false,
                    onclick: 'submit'
                }, {
                    text: 'Hủy',
                    onclick: 'close'
                }],
                classes: 'custom-dialog-wrapper',
                bodyType:'tabpanel',
                body: [
                    {
                        title: 'Tự động chèn sản phẩm',
                        name: 'autoEmbedProducts',
                        type: 'form',
                        classes: 'product-tab-container',
                        onShowTab: function(e) { 
                            editor.settings.isAutoEmbedProduct = true;
                        },
                        items: [
                            {
                                type: 'textbox',
                                name: 'limitProducts',
                                label: 'Số sản phẩm được hiển thị',
                                onkeyup: function(e) {
                                    editor.settings.autoEmbedData.limits = this.value();
                                }
                            },
                            {
                                type: 'textbox',
                                name: 'numberColumns',
                                label: 'Số cột hiển thị',
                                onkeyup: function(e) {
                                    editor.settings.autoEmbedData.cols = this.value();
                                }
                            },
                            {
                                type: 'textbox',
                                name: 'apiLink',
                                label: 'URL',
                                onkeyup: function(e) {
                                    editor.settings.autoEmbedData.link = this.value();
                                }
                            },
                        ],
                    },
                    {
                        title: 'Cấu hình chèn sản phẩm',
                        name: 'configEmbedProducts',
                        type: 'form',
                        onShowTab: function(e) { 
                            editor.settings.isAutoEmbedProduct = false;
                        },
                        items: [
                            {
                                type: 'textbox',
                                name: 'title',
                                label: 'Tên sản phẩm',
                                autofocus: true,
                                onkeyup: function(e) {
                                    editor.settings.isAutoEmbedProduct = false;
                                    var searchTitle = window.find('#title')[0];
                                    var searchValue = $("#" + searchTitle._id).val();
                                    var list = [];
                                    if(searchValue == ''){
                                        list = [{text: 'Chưa có dữ liệu', value:''}];
                                    }else{
                                        if (typeof tinyRequest != "undefined") {
                                            tinyRequest.abort();
                                        }
                                        
                                        tinyRequest = $.ajax({
                                            url: "/system/product/find",
                                            type: "post",
                                            dataType: "json",
                                            data: {
                                                keyword: searchValue,
                                            },
                                            error: function () {},
                                            beforeSend: function () {},
                                            complete: function () {},
                                            success: function(data){
                                                if (data.status == "success") {
                                                    data.products.forEach(function (product) {
                                                        if (product.title != null) {
                                                            list.push({text: product.title, value: product.code });
                                                        }
                                                    });
                                                    if (list.length <= 0) {
                                                        list = [{text: "Không tìm thấy", value: ""}];
                                                    }
                                                } else {
                                                    list = [{text: "Không tìm thấy", value: ""}];
                                                }
                                                tinyMCE.activeEditor.settings.listProducts = list;
                                                var listbox = window.find("#listProducts")[0];
                                                var formItem = listbox.parent();
                                                listbox.remove();
                                                formItem.append({
                                                    type: 'listbox',
                                                    name: 'listProducts',
                                                    multiline: true,
                                                    label: 'Chọn sản phẩm',
                                                    values: list,
                                                    onselect: function(e) {
                                                        var productListSelected = window.find('#listProducts');
                                                        var selectedList = getListSelected();
                                                        var selectedValue = {
                                                            type: 'textbox',
                                                            text: productListSelected.text(),
                                                            value: productListSelected.value(),
                                                            classes: 'selected-text-box',
                                                            tooltip: productListSelected.text(),
                                                            onclick: function(){
                                                                var items = tinyMCE.activeEditor.settings.listSeletedProduct;
                                                                var newItems = [];
                                                                for(var k = 0; k <= (items.length - 1); k++){
                                                                    if(items[k].value != this.settings.value){
                                                                        newItems.push(items[k]);
                                                                    }
                                                                }
                                                                tinyMCE.activeEditor.settings.listSeletedProduct = newItems;
                                                            }
                                                        };
                                                        var isPushed = true;
                                                        for(var i = (selectedList.length - 1); i >= 0; i-- ){
                                                            if(selectedList[i].type == 'label'){
                                                                selectedList.splice(i, 1);
                                                            }else if(selectedList[i].value == selectedValue.value){
                                                                isPushed = false;
                                                            }
                                                        }
                                                        if(isPushed){
                                                            selectedList.push(selectedValue);
                                                            selectedProducts.append(selectedValue).reflow();
                                                        }
                                                        tinyMCE.activeEditor.settings.listSeletedProduct = selectedList;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }
                            },
                            {
                                type: 'listbox',
                                name: 'listProducts',
                                multiline: true,
                                label: 'Chọn sản phẩm',
                                values: getValues(),
                                onselect: function(e) {
                                    var productListSelected = window.find('#listProducts');
                                    var selectedList = getListSelected();
                                    var selectedValue = {
                                        type: 'textbox',
                                        text: productListSelected.text(),
                                        value: productListSelected.value(),
                                        classes: 'selected-text-box',
                                        tooltip: productListSelected.text(),
                                        onclick: function(){
                                            var items = tinyMCE.activeEditor.settings.listSeletedProduct;
                                            var newItems = [];
                                            for(var k = 0; k <= (items.length - 1); k++){
                                                if(items[k].value != this.settings.value){
                                                    newItems.push(items[k]);
                                                }
                                            }
                                            tinyMCE.activeEditor.settings.listSeletedProduct = newItems;
                                        }
                                    };
                                    var isPushed = true;
                                    for(var i = (selectedList.length - 1); i >= 0; i-- ){
                                        if(selectedList[i].type == 'label'){
                                            selectedList.splice(i, 1);
                                        }else if(selectedList[i].value == selectedValue.value){
                                            isPushed = false;
                                        }
                                    }
                                    if(isPushed){
                                        selectedList.push(selectedValue);
                                        selectedProducts.append(selectedValue).reflow();
                                    }
                                    tinyMCE.activeEditor.settings.listSeletedProduct = selectedList;
                                }
                            },
                            {
                                type: 'container',
                                label: 'Sản phẩm',
                                name: 'selectedProducts',
                                minHeight: 106,
                                layout: 'flow',
                                items: getListSelected()
                            }
                        ],
                    }
                ],
                onsubmit: function (e) {
                    var insertData = '';
                    if (editor.settings.isAutoEmbedProduct) {
                        insertData = `[product limit="${editor.settings.autoEmbedData.limits}" col="${editor.settings.autoEmbedData.cols}" link="${editor.settings.autoEmbedData.link}" /]`;
                    } else {
                        var submitSelected = tinyMCE.activeEditor.settings.listSeletedProduct;
                        var codes = '';
                        for(var j = 0; j <= (submitSelected.length - 1); j++){
    
                            codes += submitSelected[j].value +',';
                        }
                        codes = codes.slice(0, -1);
                        if (codes && codes != '') {
                            insertData = `[products codes="${codes}"/]`;
                        }
                    }
                    editor.insertContent(insertData);
                },
                onclose: function (e) {
                    tinyMCE.activeEditor.settings.listSeletedProduct = [{type: 'label', text: ''}];
                    tinyMCE.activeEditor.settings.listProducts = [{text: 'Chưa có dữ liệu', value:''}];
                    selectedProducts.remove();
                    button.remove();
                    editor.windowManager.close();
                }
            });
            button = window.find("#listProducts")[0];
            selectedProducts = window.find('#selectedProducts')[0];
        }
    });

});
