tinymce.PluginManager.add('productPromotionList', function (editor, url) {
    var tinyRequest, tinyTimeout;
    editor.settings.autoEmbedData.listProductPromotions = [];

    var dropDownTags = function (options) {
        return {
            type: 'listbox',
            name: 'listproductPromotions',
            multiline: true,
            label: 'Kết quả tìm kiếm Sản phẩm có mã giảm giá',
            values: (options) ? options : [{text: 'Không xác định', value:''}],
            onselect: function(e) {
                if (!Array.isArray(editor.settings.autoEmbedData.listProductPromotions)) {
                    editor.settings.autoEmbedData.listProductPromotions = [];
                }
                if (this.value() != '' && !isNaN(this.value()) && editor.settings.autoEmbedData.listProductPromotions.indexOf(this.value()) < 0) {
                    editor.settings.autoEmbedData.listProductPromotions = [this.value()];
                }
            }
        };
    }

    editor.addButton('productPromotionList', {
        text: 'Nhúng SP có Mã giảm giá',
        icon: false,
        onclick: function () {
            var window = editor.windowManager.open({
                title: 'Chọn sản phẩm có mã giảm giá',
                width: 800,
                height: 400,
                body: [
                    {
                        type: 'textbox',
                        name: 'searchProductPromotions',
                        label: 'Tìm kiếm Sản phẩm có mã giảm giá',
                        onkeyup: function(e) {
                            var searchValue = this.value();
                            if (searchValue || searchValue != '') {
                                if (typeof tinyTimeout != "undefined") {
                                    clearTimeout(tinyTimeout);
                                }
                                tinyTimeout = setTimeout(function () {
                                    if (typeof tinyRequest != "undefined") {
                                        tinyRequest.abort();
                                    }
                                    
                                    tinyRequest = $.ajax({
                                        url: "/system/product/find-product-promotion",
                                        type: "post",
                                        dataType: "json",
                                        data: {
                                            title: searchValue,
                                            page_size: 20
                                        },
                                        success: function(response) {
                                            if (response.status == "successful") {
                                                listbox = window.find('#listproductPromotions');
                                                formItem = listbox.parent();
                                                listbox.remove();

                                                if (response.products && response.products.length != 0) {
                                                    var products = [{text: 'Không xác định', value:''}];
                                                    response.products.forEach(function (item) {
                                                        products.push({text: item.title, value: item.id });
                                                    });
                                                }
                                                formItem.append(dropDownTags(products)); //reinit
                                            }
                                        }
                                    });
                                }, 400);
                            }
                        }
                    },
                    dropDownTags()
                ],
                onsubmit: function (e) {
                    var messageFail = '';
                    if (!editor.settings.autoEmbedData.listProductPromotions || editor.settings.autoEmbedData.listProductPromotions.length == 0) {
                        messageFail += '\nMời chọn Sản phẩm có mã giảm giá';
                    }
                    if (messageFail && messageFail != '') {
                        alert('Dữ liệu không hợp lệ. Xin vui lòng kiểm tra lại\n' + messageFail);
                        return false;
                    }

                    editor.insertContent(`[productPromotions product="${editor.settings.autoEmbedData.listProductPromotions.join(',')}" /]`);
                },
                onclose: function (e) {
                    editor.settings.autoEmbedData = {};
                    editor.windowManager.close();
                }
            });
        }
    });

});
