@extends('system.layout.main', [
    'ngController' => 'SeoAutolinkController'
])
@section('title')
    <title>Auto Link Keywords</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }

        .table-keyword-link td {
            vertical-align: middle!important;
        }

        .pagination {
            margin: 0;
            margin-left: 5px;
        }

        .form-flex {
            display: flex;
        }

        .form-flex .form-group {
            margin-right: 15px;
        }

        .ellipsis-link {
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 1;
            -webkit-box-orient: vertical;
            word-break: break-all;
        }

    </style>
@endsection
@section('script')
    <script>
        const CURRENT_LOCALE = '{{ env('APP_LOCALE') }}';
        let localesList = <?= json_encode(Config::get('localization::module.locales')) ?>;
    </script>

    <script src="/modules/seo/js/autolink-manager-controller.js?v={{ config('sa.version') }}"></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="box no-border">
            <div class="box-header">
                <div class="pull-left">
                    <h3>SEO Auto Link Keywords</h3>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <input type="text" ng-keyup="$event.keyCode == 13 && refreshList()" ng-model="filters.keyword" class="form-control" placeholder="Search Anchortext">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <input type="text" ng-keyup="$event.keyCode == 13 && refreshList()" ng-model="filters.url" class="form-control" placeholder="Search Url">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <select class="form-control" ng-model="filters.status">
                                <option value="">-- Choose Status --</option>
                                <option value="enable">Enable</option>
                                <option value="disable">Disable</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <select class="form-control" ng-model="filters.category_id">
                                <option value="">-- Choose Category --</option>
                                <option value="-2">All Blog</option>
                                <option value="-1">All Product</option>
                                <optgroup label="Product Categories">
                                    <option ng-repeat="category in productCategories" value="@{{ category.id }}">@{{ category.title }}</option>
                                </optgroup>
                                <optgroup label="Post Categories">
                                    <option ng-repeat="category in postCategories" value="@{{ category.id }}">@{{ category.title }}</option>
                                </optgroup>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <button type="button" class="btn btn-primary" ng-click="refreshList()">
                                <i class="fa fa-search"></i>
                                Search
                            </button>
                            <button type="button" class="btn btn-default" ng-click="removeAllFilters()">
                                <i class="fa fa-refresh"></i>
                                Reset
                            </button>
                            <button ng-if="!uploading" ngf-select="importFile($files)" class="btn btn-info btn-upload-image">
                                <i class="fa fa-upload" aria-hidden="true"></i> Import Excel
                            </button>
                            <a class="btn btn-info" href="/modules/seo/files/AutoLink_Template.xlsx">
                                <i class="fa fa-download" aria-hidden="true"></i> Template Excel
                            </a>
                        </div>
                    </div>
                </div>

                <div ng-if="status.is_fetching_comments" style="position: absolute; width: 100%;">
                    <div class="loader">Loading...</div>
                </div>
                
                <table class="table table-bordered table-keyword-link">
                    <tr>
                        <th>No.</th>
                        <th>Anchortext (Keyword)</th>
                        <th>Title Anchortext</th>
                        <th>URL</th>
                        <th>Replace</th>
                        <th>Status</th>
                        <th>Category</th>
                        <th>
                            <button type="button" name="button" class="btn btn-success btn-flat add" 
                                style="border-radius: 5px; width: 100%;" 
                                id="btnSaveMap" ng-click="openEditForm(); mode = 'create'; status.is_changing_target = true;">
                                <i class="fa fa-plus"></i>  <span style="margin-left: 5px">Add New</span>
                            </button>
                        </th>
                    </tr>
                    <tr ng-repeat="keywordLink in keywordLinks" class="">
                        <td>@{{ keywordLink.id }}</td>
                        <td>@{{ keywordLink.keyword }}</td>
                        <td>@{{ keywordLink.title }}</td>
                        <td style="max-width: 300px;">
                            <a target="_blank" class="ellipsis-link" href="@{{ keywordLink.link }}">@{{ keywordLink.link }}</a> 
                        </td>
                        <td>@{{ keywordLink.auto }}</td>
                        <td>
                            <span ng-if="keywordLink.status == 'enable'">Enable</span>
                            <span ng-if="keywordLink.status == 'disable'">Disable</span>
                        </td>
                        <td>
                            <span ng-if="keywordLink.category">
                                @{{ keywordLink.category.title }}
                            </span>
                        </td>
                        <td style="width: 135px; text-align: center;">
                            <span ng-if="!keywordLink.is_processing || keywordLink.is_processing == 0 || keywordLink.is_processing == 1">
                                <button ng-click="openEditForm(keywordLink)" class="btn btn-primary">Edit</button>
                                <button title="Item must disabled" ng-click="deleteKeywordLink(keywordLink)" class="btn btn-default">Delete</button>
                            </span>
                            <span ng-if="keywordLink.is_processing == 1">
                                Waiting ...
                            </span>
                            <span ng-if="keywordLink.is_processing == 2">
                                <img style="width: 15px; margin-right: 2px" src="/modules/seo/images/loading-1.gif">
                                Processing ...
                                <button ng-click="refreshList()" style="margin-top: 5px;" class="btn btn-xs btn-default">Update status</button>
                            </span>
                        </td>
                    </tr>
                </table>

            </div>
            <div class="box-footer clearfix" ng-if="!state.loading && pagination.number_page > 1">
                <div class="pull-left"></div>
                <ul class="pagination pull-right">
                    <li ng-repeat="n in range(pagination.current_page - 4, pagination.current_page - 1)"
                        ng-if="n > 0" class="page-item">
                        <a ng-click="pagination.current_page = n; refreshList();" class="page-link"
                            href="#">@{{ n }}</a>
                    </li>
                    <li class="page-item active">
                        <a href="#">@{{ pagination.current_page }}</a>
                    </li>
                    <li ng-repeat="n in range(pagination.current_page + 1, pagination.current_page + 4)"
                        ng-if="n <= pagination.number_page" class="page-item">
                        <a ng-click="pagination.current_page = n; refreshList();" class="page-link"
                            href="#">@{{ n }}</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>




    @include('seo::includes.autolink-form-modal')

@endsection
